/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.util.Set;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Objects;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricsFilter;

public class MetricFiltering {
    private MetricFiltering() {
    }

    public static boolean matches(MetricsFilter filter, MetricKey key) {
        return filter == null || MetricFiltering.matchesName(key.metricName(), filter.names()) && MetricFiltering.matchesScope(key.stepName(), filter.steps());
    }

    public static boolean subPathMatches(String haystack, String needle) {
        int location = haystack.indexOf(needle);
        int end = location + needle.length();
        if (location == -1) {
            return false;
        }
        if (location != 0 && haystack.charAt(location - 1) != '/') {
            return false;
        }
        return end == haystack.length() || haystack.charAt(end) == '/';
    }

    public static boolean matchesScope(String actualScope, Set<String> scopes) {
        if (scopes.isEmpty() || scopes.contains(actualScope)) {
            return true;
        }
        for (String scope : scopes) {
            if (!MetricFiltering.subPathMatches(actualScope, scope)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesName(MetricName metricName, Set<MetricNameFilter> nameFilters) {
        if (nameFilters.isEmpty()) {
            return true;
        }
        for (MetricNameFilter nameFilter : nameFilters) {
            if (nameFilter.getName() != null && !nameFilter.getName().equals(metricName.name()) || !Objects.equal(metricName.namespace(), nameFilter.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

