/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Coders;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.WindowingStrategies;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class PCollections {
    private PCollections() {
    }

    public static RunnerApi.PCollection toProto(PCollection<?> pCollection, SdkComponents components) throws IOException {
        String coderId = components.registerCoder(pCollection.getCoder());
        String windowingStrategyId = components.registerWindowingStrategy(pCollection.getWindowingStrategy());
        return RunnerApi.PCollection.newBuilder().setUniqueName(pCollection.getName()).setCoderId(coderId).setIsBounded(PCollections.toProto(pCollection.isBounded())).setWindowingStrategyId(windowingStrategyId).build();
    }

    public static PCollection.IsBounded isBounded(RunnerApi.PCollection pCollection) {
        return PCollections.fromProto(pCollection.getIsBounded());
    }

    public static Coder<?> getCoder(RunnerApi.PCollection pCollection, RunnerApi.Components components) throws IOException {
        return Coders.fromProto(components.getCodersOrThrow(pCollection.getCoderId()), components);
    }

    public static WindowingStrategy<?, ?> getWindowingStrategy(RunnerApi.PCollection pCollection, RunnerApi.Components components) throws InvalidProtocolBufferException {
        return WindowingStrategies.fromProto(components.getWindowingStrategiesOrThrow(pCollection.getWindowingStrategyId()), components);
    }

    private static RunnerApi.IsBounded toProto(PCollection.IsBounded bounded) {
        switch (bounded) {
            case BOUNDED: {
                return RunnerApi.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return RunnerApi.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s %s", PCollection.IsBounded.class.getSimpleName(), bounded));
    }

    private static PCollection.IsBounded fromProto(RunnerApi.IsBounded isBounded) {
        switch (isBounded) {
            case BOUNDED: {
                return PCollection.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return PCollection.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.IsBounded.class.getCanonicalName(), PCollection.IsBounded.class.getCanonicalName(), isBounded));
    }
}

