/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.runners.core.StateNamespace;
import org.apache.beam.runners.direct.repackaged.runners.core.StateTag;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.HashBasedTable;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Table;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;

public abstract class StateTable {
    private final Table<StateNamespace, StateTag<?>, State> stateTable = HashBasedTable.create();

    public <StateT extends State> StateT get(StateNamespace namespace, StateTag<StateT> tag, StateContext<?> c) {
        State storage = this.stateTable.get(namespace, tag);
        if (storage != null) {
            State typedStorage = storage;
            return (StateT)typedStorage;
        }
        StateT typedStorage = tag.bind(this.binderForNamespace(namespace, c));
        this.stateTable.put(namespace, tag, (State)typedStorage);
        return typedStorage;
    }

    public void clearNamespace(StateNamespace namespace) {
        this.stateTable.rowKeySet().remove(namespace);
    }

    public void clear() {
        this.stateTable.clear();
    }

    public Iterable<State> values() {
        return this.stateTable.values();
    }

    public boolean isNamespaceInUse(StateNamespace namespace) {
        return this.stateTable.containsRow(namespace);
    }

    public Map<StateTag<?>, State> getTagsInUse(StateNamespace namespace) {
        return this.stateTable.row(namespace);
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.stateTable.rowKeySet();
    }

    protected abstract StateTag.StateBinder binderForNamespace(StateNamespace var1, StateContext<?> var2);
}

