/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Function;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Predicate;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.FluentIterable;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.CounterCell;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class LateDataUtils {
    private LateDataUtils() {
    }

    public static Instant garbageCollectionTime(BoundedWindow window, WindowingStrategy windowingStrategy) {
        return LateDataUtils.garbageCollectionTime(window, windowingStrategy.getAllowedLateness());
    }

    public static Instant garbageCollectionTime(BoundedWindow window, Duration allowedLateness) {
        if (GlobalWindow.INSTANCE.maxTimestamp().minus((ReadableDuration)allowedLateness).isBefore((ReadableInstant)window.maxTimestamp())) {
            return GlobalWindow.INSTANCE.maxTimestamp();
        }
        return window.maxTimestamp().plus((ReadableDuration)allowedLateness);
    }

    public static <K, V> Iterable<WindowedValue<V>> dropExpiredWindows(final K key, Iterable<WindowedValue<V>> elements, final TimerInternals timerInternals, final WindowingStrategy<?, ?> windowingStrategy, final CounterCell droppedDueToLateness) {
        return FluentIterable.from(elements).transformAndConcat(new Function<WindowedValue<V>, Iterable<WindowedValue<V>>>(){

            @Override
            public Iterable<WindowedValue<V>> apply(@Nullable WindowedValue<V> input) {
                if (input == null) {
                    return null;
                }
                return input.explodeWindows();
            }
        }).filter(new Predicate<WindowedValue<V>>(){

            @Override
            public boolean apply(@Nullable WindowedValue<V> input) {
                if (input == null) {
                    return false;
                }
                BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement(input.getWindows());
                boolean expired = window.maxTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)timerInternals.currentInputWatermarkTime());
                if (expired) {
                    droppedDueToLateness.inc();
                    WindowTracing.debug((String)"GroupAlsoByWindow: Dropping element at {} for key: {}; window: {} since it is too far behind inputWatermark: {}", (Object[])new Object[]{input.getTimestamp(), key, window, timerInternals.currentInputWatermarkTime()});
                }
                return !expired;
            }
        });
    }
}

