/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.ArrayList;
import org.apache.beam.runners.direct.repackaged.runners.core.GroupAlsoByWindowsDoFn;
import org.apache.beam.runners.direct.repackaged.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.OldDoFn;
import org.apache.beam.runners.direct.repackaged.runners.core.ReduceFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternalsFactory;
import org.apache.beam.runners.direct.repackaged.runners.core.SystemReduceFn;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.WindowingInternalsAdapters;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Triggers;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.TriggerStateMachines;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Instant;

@SystemDoFnInternal
public class GroupAlsoByWindowViaOutputBufferDoFn<K, InputT, OutputT, W extends BoundedWindow>
extends GroupAlsoByWindowsDoFn<K, InputT, OutputT, W> {
    private final WindowingStrategy<?, W> strategy;
    private final StateInternalsFactory<K> stateInternalsFactory;
    private SystemReduceFn<K, InputT, ?, OutputT, W> reduceFn;

    public GroupAlsoByWindowViaOutputBufferDoFn(WindowingStrategy<?, W> windowingStrategy, StateInternalsFactory<K> stateInternalsFactory, SystemReduceFn<K, InputT, ?, OutputT, W> reduceFn) {
        this.strategy = windowingStrategy;
        this.reduceFn = reduceFn;
        this.stateInternalsFactory = stateInternalsFactory;
    }

    @Override
    public void processElement(OldDoFn.ProcessContext c) throws Exception {
        Object key = ((KV)c.element()).getKey();
        InMemoryTimerInternals timerInternals = new InMemoryTimerInternals();
        timerInternals.advanceProcessingTime(Instant.now());
        timerInternals.advanceSynchronizedProcessingTime(Instant.now());
        StateInternals stateInternals = this.stateInternalsFactory.stateInternalsForKey(key);
        ReduceFnRunner reduceFnRunner = new ReduceFnRunner(key, this.strategy, ExecutableTriggerStateMachine.create(TriggerStateMachines.stateMachineForTrigger(Triggers.toProto(this.strategy.getTrigger()))), stateInternals, timerInternals, WindowingInternalsAdapters.outputWindowedValue(c.windowingInternals()), WindowingInternalsAdapters.sideInputReader(c.windowingInternals()), this.reduceFn, c.getPipelineOptions());
        reduceFnRunner.processElements((Iterable)((KV)c.element()).getValue());
        timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        this.fireEligibleTimers(timerInternals, reduceFnRunner);
        reduceFnRunner.persist();
    }

    private void fireEligibleTimers(InMemoryTimerInternals timerInternals, ReduceFnRunner<K, InputT, OutputT, W> reduceFnRunner) throws Exception {
        ArrayList<TimerInternals.TimerData> timers = new ArrayList<TimerInternals.TimerData>();
        while (true) {
            TimerInternals.TimerData timer;
            if ((timer = timerInternals.removeNextEventTimer()) != null) {
                timers.add(timer);
                continue;
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                timers.add(timer);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                timers.add(timer);
            }
            if (timers.isEmpty()) break;
            reduceFnRunner.onTimers(timers);
            timers.clear();
        }
    }
}

