/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.runners.direct.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Supplier;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Suppliers;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformReplacements;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

class WriteWithShardingFactory<InputT>
implements PTransformOverrideFactory<PCollection<InputT>, PDone, WriteFiles<InputT>> {
    static final int MAX_RANDOM_EXTRA_SHARDS = 3;
    @VisibleForTesting
    static final int MIN_SHARDS_FOR_LOG = 3;

    WriteWithShardingFactory() {
    }

    public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PDone> getReplacementTransform(AppliedPTransform<PCollection<InputT>, PDone, WriteFiles<InputT>> transform) {
        return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), (PTransform)((WriteFiles)transform.getTransform()).withSharding(new LogElementShardsWithDrift()));
    }

    public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PDone newOutput) {
        return Collections.emptyMap();
    }

    private static class BoundedRandomIntSupplier
    implements Supplier<Integer>,
    Serializable {
        private final int upperBound;

        private BoundedRandomIntSupplier(int upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public Integer get() {
            return ThreadLocalRandom.current().nextInt(0, this.upperBound);
        }
    }

    @VisibleForTesting
    static class CalculateShardsFn
    extends DoFn<Long, Integer> {
        private final Supplier<Integer> extraShardsSupplier;

        public CalculateShardsFn() {
            this(new BoundedRandomIntSupplier(3));
        }

        @VisibleForTesting
        CalculateShardsFn(int constantExtraShards) {
            this(Suppliers.ofInstance(constantExtraShards));
        }

        private CalculateShardsFn(Supplier<Integer> extraShardsSupplier) {
            this.extraShardsSupplier = extraShardsSupplier;
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext ctxt) {
            ctxt.output((Object)this.calculateShards((Long)ctxt.element()));
        }

        private int calculateShards(long totalRecords) {
            if (totalRecords == 0L) {
                return 1;
            }
            int extraShards = this.extraShardsSupplier.get();
            if (totalRecords < (long)(3 + extraShards)) {
                return (int)totalRecords;
            }
            int floorLogRecs = Double.valueOf(Math.log10(totalRecords)).intValue();
            return Math.max(floorLogRecs, 3) + extraShards;
        }
    }

    private static class LogElementShardsWithDrift<T>
    extends PTransform<PCollection<T>, PCollectionView<Integer>> {
        private LogElementShardsWithDrift() {
        }

        public PCollectionView<Integer> expand(PCollection<T> records) {
            return (PCollectionView)((PCollection)((PCollection)((PCollection)records.apply((PTransform)Window.into((WindowFn)new GlobalWindows()))).apply("CountRecords", Count.globally())).apply("GenerateShardCount", (PTransform)ParDo.of((DoFn)new CalculateShardsFn()))).apply((PTransform)View.asSingleton());
        }
    }
}

