/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.test;

import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionIsRunningException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SynchronousJobOperator
implements JobOperator {
    private static final Collection<BatchStatus> BATCH_END_STATUSES = Arrays.asList(BatchStatus.COMPLETED, BatchStatus.FAILED, BatchStatus.STOPPED, BatchStatus.ABANDONED);
    private volatile JobOperator delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobOperator getOrCreateDelegate() {
        if (this.delegate == null) {
            SynchronousJobOperator synchronousJobOperator = this;
            synchronized (synchronousJobOperator) {
                if (this.delegate == null) {
                    this.delegate = BatchRuntime.getJobOperator();
                }
            }
        }
        return this.delegate;
    }

    private void waitEnd(long id) {
        try {
            Class<?> batcheeOpClass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.batchee.container.impl.JobOperatorImpl");
            if (batcheeOpClass.isInstance(this.delegate)) {
                batcheeOpClass.getMethod("waitFor", Long.TYPE).invoke((Object)this.delegate, id);
                return;
            }
            return;
        }
        catch (Exception batcheeOpClass) {
            do {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    return;
                }
            } while (!BATCH_END_STATUSES.contains(this.delegate.getJobExecution(id).getBatchStatus()));
            return;
        }
    }

    public long start(String name, Properties properties) throws JobStartException, JobSecurityException {
        long id = this.getOrCreateDelegate().start(name, properties);
        this.waitEnd(id);
        return id;
    }

    public long restart(long id, Properties properties) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long newId = this.getOrCreateDelegate().restart(id, properties);
        this.waitEnd(newId);
        return newId;
    }

    public void stop(long id) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.getOrCreateDelegate().stop(id);
        this.waitEnd(id);
    }

    public void abandon(long id) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        this.getOrCreateDelegate().abandon(id);
        this.waitEnd(id);
    }

    public Set<String> getJobNames() throws JobSecurityException {
        return this.getOrCreateDelegate().getJobNames();
    }

    public int getJobInstanceCount(String name) throws NoSuchJobException, JobSecurityException {
        return this.getOrCreateDelegate().getJobInstanceCount(name);
    }

    public List<JobInstance> getJobInstances(String name, int start, int count) throws NoSuchJobException, JobSecurityException {
        return this.getOrCreateDelegate().getJobInstances(name, start, count);
    }

    public List<Long> getRunningExecutions(String name) throws NoSuchJobException, JobSecurityException {
        return this.getOrCreateDelegate().getRunningExecutions(name);
    }

    public Properties getParameters(long id) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getOrCreateDelegate().getParameters(id);
    }

    public JobInstance getJobInstance(long id) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getOrCreateDelegate().getJobInstance(id);
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) throws NoSuchJobInstanceException, JobSecurityException {
        return this.getOrCreateDelegate().getJobExecutions(jobInstance);
    }

    public JobExecution getJobExecution(long id) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getOrCreateDelegate().getJobExecution(id);
    }

    public List<StepExecution> getStepExecutions(long id) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getOrCreateDelegate().getStepExecutions(id);
    }
}

