/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.test;

import java.util.List;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.jsl.JobModelResolver;
import org.apache.batchee.container.services.loader.DefaultJobXMLLoaderService;
import org.apache.batchee.jaxb.Batchlet;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.End;
import org.apache.batchee.jaxb.Fail;
import org.apache.batchee.jaxb.ItemProcessor;
import org.apache.batchee.jaxb.ItemReader;
import org.apache.batchee.jaxb.ItemWriter;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.jaxb.Next;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.jaxb.Stop;

public class StepBuilder {
    private final Step step = new Step();

    public static Step extractFromXml(String xml, String name) {
        JSLJob job = new JobModelResolver().resolveModel(new DefaultJobXMLLoaderService().loadJSL(xml.replace(".xml", "")));
        if (name != null) {
            for (ExecutionElement step : job.getExecutionElements()) {
                if (!Step.class.isInstance(step) || !name.equals(((Step)Step.class.cast(step)).getId())) continue;
                return (Step)Step.class.cast(step);
            }
        }
        if (job.getExecutionElements().size() == 1) {
            return (Step)Step.class.cast(job.getExecutionElements().iterator().next());
        }
        throw new IllegalArgumentException("Step '" + name + "' nor found.");
    }

    public static StepBuilder newStep() {
        return new StepBuilder();
    }

    public static BatchletBuilder newBatchlet() {
        return new StepBuilder().batchlet();
    }

    public static ChunkBuilder newChunk() {
        return new StepBuilder().chunk();
    }

    private StepBuilder() {
    }

    public BatchletBuilder batchlet() {
        Batchlet batchlet = new Batchlet();
        batchlet.setProperties(new JSLProperties());
        this.step.setBatchlet(batchlet);
        return new BatchletBuilder(batchlet, this);
    }

    public ChunkBuilder chunk() {
        Chunk chunk = new Chunk();
        this.step.setChunk(chunk);
        return new ChunkBuilder(chunk, this);
    }

    public StepBuilder property(String key, String value) {
        StepBuilder.addProperty(key, value, this.step.getProperties().getPropertyList());
        return this;
    }

    public StepBuilder name(String name) {
        this.step.setId(name);
        return this;
    }

    public StepBuilder failOn(String on) {
        return this.failOn(on, null);
    }

    public StepBuilder failOn(String on, String exitStatus) {
        Fail fail = new Fail();
        fail.setOn(on);
        fail.setExitStatus(exitStatus);
        this.step.getTransitionElements().add(fail);
        return this;
    }

    public StepBuilder endOn(String on) {
        return this.endOn(on, null);
    }

    public StepBuilder endOn(String on, String exitStatus) {
        End end = new End();
        end.setOn(on);
        end.setExitStatus(exitStatus);
        this.step.getTransitionElements().add(end);
        return this;
    }

    public StepBuilder stopOn(String on, String restart) {
        return this.stopOn(on, restart, null);
    }

    public StepBuilder stopOn(String on, String restart, String exitStatus) {
        Stop stop = new Stop();
        stop.setOn(on);
        stop.setExitStatus(exitStatus);
        stop.setRestart(restart);
        this.step.getTransitionElements().add(stop);
        return this;
    }

    public StepBuilder nextOn(String on, String to) {
        Next next = new Next();
        next.setOn(on);
        next.setTo(to);
        this.step.getTransitionElements().add(next);
        return this;
    }

    public Step create() {
        if (this.step.getId() == null) {
            this.step.setId("batchee-test");
        }
        return this.step;
    }

    private static void addProperty(String key, String value, List<Property> propertyList) {
        Property e = new Property();
        e.setName(key);
        e.setValue(value);
        propertyList.add(e);
    }

    public static class BatchletBuilder {
        private final Batchlet toBuild;
        private final StepBuilder parent;

        private BatchletBuilder(Batchlet batchlet, StepBuilder stepBuilder) {
            this.toBuild = batchlet;
            this.parent = stepBuilder;
        }

        public BatchletBuilder ref(String ref) {
            this.toBuild.setRef(ref);
            return this;
        }

        public BatchletBuilder property(String key, String value) {
            StepBuilder.addProperty(key, value, this.toBuild.getProperties().getPropertyList());
            return this;
        }

        public StepBuilder up() {
            return this.parent;
        }

        public Step create() {
            return this.up().create();
        }
    }

    public static class ChunkBuilder {
        private final StepBuilder parent;
        private final Chunk toBuild;

        private ChunkBuilder(Chunk chunk, StepBuilder stepBuilder) {
            this.toBuild = chunk;
            this.parent = stepBuilder;
        }

        public ReaderBuilder reader() {
            ItemReader reader = new ItemReader();
            reader.setProperties(new JSLProperties());
            this.toBuild.setReader(reader);
            return new ReaderBuilder(reader, this);
        }

        public ProcessorBuilder processor() {
            ItemProcessor processor = new ItemProcessor();
            processor.setProperties(new JSLProperties());
            this.toBuild.setProcessor(processor);
            return new ProcessorBuilder(processor, this);
        }

        public WriterBuilder writer() {
            ItemWriter writer = new ItemWriter();
            writer.setProperties(new JSLProperties());
            this.toBuild.setWriter(writer);
            return new WriterBuilder(writer, this);
        }

        public ChunkBuilder retryLimit(int retry) {
            this.toBuild.setRetryLimit(Integer.toString(retry));
            return this;
        }

        public ChunkBuilder checkpointPolicy(String policy) {
            this.toBuild.setCheckpointPolicy(policy);
            return this;
        }

        public StepBuilder up() {
            return this.parent;
        }
    }

    public static class ReaderBuilder {
        private final ItemReader toBuild;
        private final ChunkBuilder parent;

        private ReaderBuilder(ItemReader batchlet, ChunkBuilder stepBuilder) {
            this.toBuild = batchlet;
            this.parent = stepBuilder;
        }

        public ReaderBuilder ref(String ref) {
            this.toBuild.setRef(ref);
            return this;
        }

        public ReaderBuilder property(String key, String value) {
            StepBuilder.addProperty(key, value, this.toBuild.getProperties().getPropertyList());
            return this;
        }

        public ProcessorBuilder processor() {
            return this.up().processor();
        }

        public WriterBuilder writer() {
            return this.up().writer();
        }

        public ChunkBuilder up() {
            return this.parent;
        }
    }

    public static class ProcessorBuilder {
        private final ItemProcessor toBuild;
        private final ChunkBuilder parent;

        private ProcessorBuilder(ItemProcessor batchlet, ChunkBuilder stepBuilder) {
            this.toBuild = batchlet;
            this.parent = stepBuilder;
        }

        public ProcessorBuilder ref(String ref) {
            this.toBuild.setRef(ref);
            return this;
        }

        public ProcessorBuilder property(String key, String value) {
            StepBuilder.addProperty(key, value, this.toBuild.getProperties().getPropertyList());
            return this;
        }

        public WriterBuilder writer() {
            return this.up().writer();
        }

        public ChunkBuilder up() {
            return this.parent;
        }
    }

    public static class WriterBuilder {
        private final ItemWriter toBuild;
        private final ChunkBuilder parent;

        private WriterBuilder(ItemWriter batchlet, ChunkBuilder stepBuilder) {
            this.toBuild = batchlet;
            this.parent = stepBuilder;
        }

        public WriterBuilder ref(String ref) {
            this.toBuild.setRef(ref);
            return this;
        }

        public WriterBuilder property(String key, String value) {
            StepBuilder.addProperty(key, value, this.toBuild.getProperties().getPropertyList());
            return this;
        }

        public ChunkBuilder up() {
            return this.parent;
        }

        public Step create() {
            return this.up().up().create();
        }
    }
}

