/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven.doc;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public abstract class ComponentDocumentationGenerator {
    private static final String OBJECT_NAME = "java/lang/Object";
    private static final String PROPERTY_MARKER = "Ljavax/batch/api/BatchProperty;";
    private static final String NAMED_MARKER = "Ljavax/inject/Named;";
    private static final String INJECT_MARKER = "Ljavax/inject/Inject;";
    private static final String CONFIGURATION_MARKER = "Lorg/apache/batchee/doc/api/Documentation;";
    protected final File classes;
    protected final File output;
    protected final String formatter;

    protected ComponentDocumentationGenerator(File classes, File output, String formatter) {
        this.classes = classes;
        this.output = output;
        this.formatter = formatter;
    }

    public static void main(String[] args) {
        new ComponentDocumentationGenerator(new File(args[0]), new File(args[1]), args[2]){

            @Override
            protected void warn(String s) {
                System.err.println(s);
            }
        }.execute();
    }

    public void execute() {
        if (this.classes == null || !this.classes.isDirectory()) {
            this.warn((this.classes != null ? this.classes.getAbsolutePath() : "null") + " is not a directory, skipping");
            return;
        }
        Formatter formatterInstance = this.createFormatter();
        TreeMap<String, ClassDoc> configByComponent = new TreeMap<String, ClassDoc>();
        try {
            this.scan(configByComponent, this.classes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (configByComponent.isEmpty()) {
            this.warn("Nothing found, maybe adjust <classes>, skipping.");
            return;
        }
        this.handleParents(configByComponent);
        if (!this.output.getParentFile().isDirectory() && !this.output.getParentFile().mkdirs()) {
            throw new IllegalStateException("Can't create " + this.output.getAbsolutePath());
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.output);
            formatterInstance.begin(writer);
            for (Map.Entry component : configByComponent.entrySet()) {
                ClassDoc value = (ClassDoc)component.getValue();
                if (!value.leaf) continue;
                formatterInstance.beginClass(writer, value.name, value.doc);
                for (FieldDoc doc : value.configuration) {
                    formatterInstance.add(writer, doc);
                }
                formatterInstance.endClass(writer);
            }
            formatterInstance.end(writer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void warn(String var1);

    private void handleParents(Map<String, ClassDoc> configByComponent) {
        for (Map.Entry<String, ClassDoc> component : configByComponent.entrySet()) {
            String parent = component.getValue().parent;
            while (parent != null) {
                ClassDoc doc = configByComponent.get(parent);
                if (doc != null) {
                    component.getValue().configuration.addAll(doc.configuration);
                    Collections.sort(component.getValue().configuration);
                    parent = doc.parent;
                    continue;
                }
                parent = null;
            }
        }
    }

    private Formatter createFormatter() {
        if (this.formatter == null || this.formatter.startsWith("adoc")) {
            int level = "adoc".equals(this.formatter) || this.formatter == null ? 1 : Integer.parseInt(this.formatter.substring("adoc".length()));
            final String prefix = this.buildPrefix('=', level);
            return new Formatter(){

                @Override
                public void begin(Writer writer) throws IOException {
                }

                @Override
                public void beginClass(Writer writer, String className, String doc) throws IOException {
                    writer.append(prefix).append(" ").append(className).append("\n\n");
                    if (doc != null) {
                        writer.append(doc).append("\n\n");
                    }
                    writer.append("|===\n|Name|Description\n");
                }

                @Override
                public void add(Writer writer, FieldDoc doc) throws IOException {
                    writer.append("|").append(doc.getName()).append("|").append(doc.getDoc() == null ? "-" : doc.getDoc()).append("\n");
                }

                @Override
                public void endClass(Writer writer) throws IOException {
                    writer.append("|===\n\n");
                }

                @Override
                public void end(Writer writer) throws IOException {
                }
            };
        }
        if (this.formatter.startsWith("md")) {
            final String prefix = this.buildPrefix('#', "md".equals(this.formatter) ? 1 : Integer.parseInt(this.formatter.substring("md".length())));
            return new Formatter(){

                @Override
                public void begin(Writer writer) throws IOException {
                }

                @Override
                public void beginClass(Writer writer, String className, String doc) throws IOException {
                    writer.append(prefix).append(" ").append(className).append("\n\n");
                    if (doc != null) {
                        writer.append(doc).append("\n\n");
                    }
                }

                @Override
                public void add(Writer writer, FieldDoc doc) throws IOException {
                    writer.append("* `").append(doc.getName()).append('`').append(doc.getDoc() == null ? "" : ": " + doc.getDoc()).append("\n");
                }

                @Override
                public void endClass(Writer writer) throws IOException {
                    writer.append('\n');
                }

                @Override
                public void end(Writer writer) throws IOException {
                }
            };
        }
        try {
            return (Formatter)Formatter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.formatter.trim()).newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String buildPrefix(char c, int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append(c);
        }
        String prefix = builder.toString();
        return prefix;
    }

    private void scan(Map<String, ClassDoc> commands, File file) throws IOException {
        File[] children;
        if (file.isFile()) {
            if (file.getName().endsWith(".class")) {
                this.component(commands, file);
            }
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.scan(commands, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String component(final Map<String, ClassDoc> commands, File classFile) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(classFile);
            ClassReader reader = new ClassReader((InputStream)stream);
            reader.accept(new ClassVisitor(327680){
                public boolean isLeaf;
                private String parentName;
                private String configName;
                private String className;
                private String doc;
                private List<FieldDoc> configs;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.parentName = superName == null || ComponentDocumentationGenerator.OBJECT_NAME.equals(superName) ? null : superName.replace('/', '.');
                    this.className = name.replace('/', '.');
                    this.isLeaf = !Modifier.isAbstract(access);
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor annotationVisitor = super.visitAnnotation(desc, visible);
                    if (ComponentDocumentationGenerator.NAMED_MARKER.equals(desc)) {
                        this.configName = this.className;
                        int dollar = this.configName.lastIndexOf(36);
                        if (dollar > 0) {
                            this.configName = this.configName.substring(dollar + 1);
                        } else {
                            int dot = this.configName.lastIndexOf(46);
                            if (dot > 0) {
                                this.configName = this.configName.substring(dot + 1);
                            }
                        }
                        this.configName = Introspector.decapitalize(this.configName);
                        return new AnnotationVisitor(327680, annotationVisitor){

                            public void visit(String name, Object value) {
                                super.visit(name, value);
                                if ("value".equals(name) && String.class.isInstance(value) && !((String)String.class.cast(value)).isEmpty()) {
                                    configName = value.toString();
                                }
                            }
                        };
                    }
                    if (ComponentDocumentationGenerator.CONFIGURATION_MARKER.equals(desc)) {
                        return new AnnotationVisitor(327680, annotationVisitor){

                            public void visit(String name, Object value) {
                                super.visit(name, value);
                                if ("value".equals(name) && String.class.isInstance(value) && !((String)String.class.cast(value)).isEmpty()) {
                                    doc = value.toString();
                                }
                            }
                        };
                    }
                    return annotationVisitor;
                }

                public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                    return new FieldVisitor(327680, super.visitField(access, name, desc, signature, value)){
                        private boolean marked;
                        private boolean hasInject;
                        private String configName;
                        private String doc;
                        {
                            super(arg0, arg1);
                            this.marked = false;
                            this.hasInject = false;
                            this.configName = name;
                            this.doc = null;
                        }

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationVisitor annotationVisitor = super.visitAnnotation(desc, visible);
                            if (ComponentDocumentationGenerator.PROPERTY_MARKER.equals(desc)) {
                                this.marked = true;
                                return new AnnotationVisitor(327680, annotationVisitor){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        if ("name".equals(name) && String.class.isInstance(value) && !((String)String.class.cast(value)).isEmpty()) {
                                            configName = value.toString();
                                        }
                                    }
                                };
                            }
                            if (ComponentDocumentationGenerator.INJECT_MARKER.equals(desc)) {
                                this.hasInject = true;
                                return annotationVisitor;
                            }
                            if (ComponentDocumentationGenerator.CONFIGURATION_MARKER.equals(desc)) {
                                return new AnnotationVisitor(327680, annotationVisitor){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        if ("value".equals(name) && String.class.isInstance(value) && !((String)String.class.cast(value)).isEmpty()) {
                                            doc = value.toString();
                                        }
                                    }
                                };
                            }
                            return annotationVisitor;
                        }

                        public void visitEnd() {
                            super.visitEnd();
                            if (this.marked && this.hasInject) {
                                if (configs == null) {
                                    configs = new ArrayList();
                                }
                                configs.add(new FieldDoc(this.configName, this.doc));
                            }
                        }
                    };
                }

                public void visitEnd() {
                    super.visitEnd();
                    if (this.configs != null) {
                        Collections.sort(this.configs);
                        commands.put(this.className, new ClassDoc(this.isLeaf, this.parentName, this.configName == null ? this.className : this.configName, this.doc, this.configs));
                    }
                }
            }, 7);
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static interface Formatter {
        public void begin(Writer var1) throws IOException;

        public void beginClass(Writer var1, String var2, String var3) throws IOException;

        public void add(Writer var1, FieldDoc var2) throws IOException;

        public void endClass(Writer var1) throws IOException;

        public void end(Writer var1) throws IOException;
    }

    public static class FieldDoc
    implements Comparable<FieldDoc> {
        private final String name;
        private final String doc;

        private FieldDoc(String name, String doc) {
            this.name = name;
            this.doc = doc;
        }

        @Override
        public int compareTo(FieldDoc o) {
            return this.name.compareTo(o.name);
        }

        public String getName() {
            return this.name;
        }

        public String getDoc() {
            return this.doc;
        }
    }

    public static class ClassDoc {
        private final boolean leaf;
        private final String parent;
        private final String name;
        private final String doc;
        private final List<FieldDoc> configuration;

        public ClassDoc(boolean isLeaf, String parent, String name, String doc, List<FieldDoc> configuration) {
            this.leaf = isLeaf;
            this.parent = parent;
            this.name = name;
            this.doc = doc;
            this.configuration = configuration;
        }
    }
}

