/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven;

import java.util.Map;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.ServicesManagerLocator;
import org.apache.batchee.jaxrs.client.BatchEEJAXRSClientFactory;
import org.apache.batchee.jaxrs.client.ClientConfiguration;
import org.apache.batchee.tools.maven.locator.MavenPluginLocator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class BatchEEMojoBase
extends AbstractMojo {
    @Parameter
    protected Map<String, String> properties;
    @Parameter
    private ClientConfiguration clientConfiguration;
    @Parameter(property="batchee.job-operator")
    private String jobOperatorClass;
    protected volatile JobOperator operator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobOperator getOrCreateOperator() {
        if (this.operator == null) {
            BatchEEMojoBase batchEEMojoBase = this;
            synchronized (batchEEMojoBase) {
                if (this.operator == null) {
                    if (this.jobOperatorClass != null) {
                        try {
                            this.operator = (JobOperator)JobOperator.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.jobOperatorClass).newInstance());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("JobOperator " + this.jobOperatorClass + " can't be used", e);
                        }
                    } else if (this.clientConfiguration == null) {
                        this.configureBatchEE();
                        this.operator = BatchRuntime.getJobOperator();
                    } else {
                        this.operator = BatchEEJAXRSClientFactory.newClient((ClientConfiguration)this.clientConfiguration);
                    }
                }
            }
        }
        return this.operator;
    }

    private void configureBatchEE() {
        try {
            MavenPluginLocator locator = new MavenPluginLocator();
            locator.init(this.properties);
            ServicesManager.setServicesManagerLocator((ServicesManagerLocator)locator);
        }
        catch (Throwable th) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.apache.batchee.container.services.ServicesManager");
                this.getLog().error((CharSequence)th.getMessage(), th);
            }
            catch (Throwable ignored) {
                this.getLog().info((CharSequence)"You don't use this plugin with BatchEE so configuration will be ignored");
            }
        }
    }
}

