/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

@Mojo(name="bar", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class BarMojo
extends AbstractMojo {
    private static final BatchDescriptorSelector JOB_SELECTOR = new BatchDescriptorSelector();
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    private MavenProjectHelper helper;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${localRepository}")
    protected ArtifactRepository localRepo;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepos;
    @Component(role=ProjectDependenciesResolver.class)
    protected ProjectDependenciesResolver resolver;
    @Parameter(defaultValue="${session}", required=true)
    protected MavenSession session;
    @Parameter(property="batchee.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="batchee.classifier")
    private String classifier;
    @Parameter(property="batchee.classes", defaultValue="${project.build.directory}/classes")
    private File classes;
    @Parameter(property="batchee.maven-descriptors", defaultValue="true")
    private boolean mavenDescriptors;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classifier == null && !"bar".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Packaging type is not 'bar' so ignoring bar creation");
            return;
        }
        File bar = this.createBar();
        if (this.classifier != null) {
            this.helper.attachArtifact(this.project, "bar", this.classifier, bar);
        } else {
            this.project.getArtifact().setFile(bar);
        }
    }

    private File createBar() throws MojoExecutionException {
        File target = new File(this.outputDirectory, this.finalName + (this.classifier != null ? this.classifier : "") + ".bar");
        try {
            for (Artifact dependency : this.resolver.resolve(this.project, Arrays.asList("compile", "runtime", "system"), this.session)) {
                if ("provided".equals(dependency.getScope())) continue;
                this.jarArchiver.addFile(dependency.getFile(), "BATCH-INF/lib/" + BarMojo.artifactPath(dependency));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.classes.isDirectory()) {
            FileSelector classesSelector = new FileSelector(){

                public boolean isSelected(FileInfo fileInfo) throws IOException {
                    return !JOB_SELECTOR.isSelected(fileInfo);
                }
            };
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setDirectory(this.classes);
            fileSet.setIncludingEmptyDirectories(false);
            fileSet.setPrefix("BATCH-INF/classes/");
            fileSet.setFileSelectors(new FileSelector[]{classesSelector});
            this.jarArchiver.addFileSet((FileSet)fileSet);
            fileSet.setPrefix("BATCH-INF/");
            fileSet.setFileSelectors(new FileSelector[]{JOB_SELECTOR});
            this.jarArchiver.addFileSet((FileSet)fileSet);
        }
        MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
        archiveConfiguration.setAddMavenDescriptor(this.mavenDescriptors);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setOutputFile(target);
        archiver.setArchiver(new JarArchiver(){
            {
                this.archiveType = "bar";
            }

            public void addFile(File inputFile, String destFileName) throws ArchiverException {
                BarMojo.this.jarArchiver.addFile(inputFile, destFileName);
            }

            public ResourceIterator getResources() throws ArchiverException {
                final Iterator<ResourceIterator> iterators = Arrays.asList(BarMojo.this.jarArchiver.getResources(), super.getResources()).iterator();
                return new ResourceIterator(){
                    private ResourceIterator ri;
                    {
                        this.ri = (ResourceIterator)iterators.next();
                    }

                    public boolean hasNext() {
                        if (this.ri.hasNext()) {
                            return true;
                        }
                        if (iterators.hasNext()) {
                            this.ri = (ResourceIterator)iterators.next();
                        }
                        return this.ri.hasNext();
                    }

                    public ArchiveEntry next() {
                        ArchiveEntry next = this.ri.next();
                        PlexusIoResource resource = next.getResource();
                        if (resource != null && PlexusIoFileResource.class.isInstance(resource)) {
                            File file = ((PlexusIoFileResource)PlexusIoFileResource.class.cast(resource)).getFile();
                            String name = next.getName();
                            if (JOB_SELECTOR.accept(resource.getName())) {
                                return ArchiveEntry.createEntry((String)name.replace(File.separatorChar, '/').replaceFirst("META\\-INF/", ""), (File)file, (int)next.getType(), (int)next.getMode());
                            }
                        }
                        return next;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        try {
            archiver.createArchive(this.session, this.project, archiveConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        return target;
    }

    private static String artifactPath(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId());
        sb.append("-");
        if (artifact.hasClassifier()) {
            sb.append(artifact.getClassifier());
            sb.append("-");
        }
        if (artifact.getBaseVersion() != null) {
            sb.append(artifact.getBaseVersion());
        } else if (artifact.getVersion() != null) {
            sb.append(artifact.getVersion());
        } else {
            sb.append(artifact.getVersionRange().toString());
        }
        sb.append('.').append(artifact.getType());
        return sb.toString();
    }

    private static class BatchDescriptorSelector
    implements FileSelector {
        private static final String JOB_XML_PATH = "META-INF/batch-jobs/";

        private BatchDescriptorSelector() {
        }

        public boolean isSelected(FileInfo fileInfo) throws IOException {
            String name = fileInfo.getName();
            return this.accept(name);
        }

        public boolean accept(String name) {
            String nameWithoutSlash = name.startsWith("/") ? name.substring(1) : name;
            return nameWithoutSlash.replace('\\', '/').startsWith(JOB_XML_PATH) && nameWithoutSlash.endsWith(".xml") || "META-INF/batch.xml".equals(name) || "META-INF/batchee.xml".equals(name);
        }
    }
}

