/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import net.sf.jsefa.Serializer;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.TransactionalWriter;

public abstract class JSefaWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="object types to use")
    protected String objectTypes;
    @Inject
    @BatchProperty
    @Documentation(value="validation mode (AUTO, CALLBACK, NONE)")
    protected String validationMode;
    @Inject
    @BatchProperty
    @Documentation(value="object accessor provider implementation")
    protected String objectAccessorProvider;
    @Inject
    @BatchProperty
    @Documentation(value="validation provider implementation")
    protected String validationProvider;
    @Inject
    @BatchProperty
    @Documentation(value="simple type provider implementation")
    protected String simpleTypeProvider;
    @Inject
    @BatchProperty
    @Documentation(value="type mapping registry to use")
    protected String typeMappingRegistry;
    @Inject
    @BatchProperty
    @Documentation(value="file to write")
    protected String file;
    @Inject
    @BatchProperty
    @Documentation(value="output file encoding")
    protected String encoding;
    protected Serializer serializer;
    protected TransactionalWriter transactionalWriter;

    public void open(Serializable checkpoint) throws Exception {
        File f = new File(this.file);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new BatchRuntimeException(f.getParentFile().getAbsolutePath());
        }
        this.serializer = this.createSerializer();
        this.transactionalWriter = new TransactionalWriter(f, this.encoding, checkpoint);
        this.serializer.open((Writer)this.transactionalWriter);
    }

    protected abstract Serializer createSerializer() throws Exception;

    public void close() throws Exception {
        if (this.serializer != null) {
            this.serializer.close(true);
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.serializer.write(item);
        }
        this.transactionalWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.transactionalWriter.position());
    }
}

