/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.jobinstance;

import java.io.Closeable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.JobExecutionImpl;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.proxy.ListenerFactory;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.spi.PersistenceManagerService;

public class RuntimeJobExecution {
    private ModelNavigator<JSLJob> jobNavigator = null;
    private JobInstance jobInstance;
    private long executionId;
    private String restartOn;
    private JobContextImpl jobContext = null;
    private ListenerFactory listenerFactory;
    private InternalJobExecution operatorJobExecution = null;
    private Integer partitionInstance = null;
    private Collection<Closeable> releasables = new ArrayList<Closeable>();

    public RuntimeJobExecution(JobInstance jobInstance, long executionId, PersistenceManagerService persistenceManagerService) {
        this.jobInstance = jobInstance;
        this.executionId = executionId;
        this.operatorJobExecution = new JobExecutionImpl(executionId, jobInstance.getInstanceId(), persistenceManagerService);
    }

    public void prepareForExecution(JobContextImpl jobContext, String restartOn) {
        this.jobContext = jobContext;
        this.jobNavigator = jobContext.getNavigator();
        jobContext.setExecutionId(this.executionId);
        jobContext.setInstanceId(this.jobInstance.getInstanceId());
        this.restartOn = restartOn;
        this.operatorJobExecution.setJobContext(jobContext);
    }

    public void prepareForExecution(JobContextImpl jobContext) {
        this.prepareForExecution(jobContext, null);
    }

    public void inheritJobContext(JobContextImpl jc) {
        this.jobContext.setExecutionId(jc.getExecutionId());
        this.jobContext.setInstanceId(jc.getInstanceId());
        this.jobContext.setJobName(jc.getJobName());
    }

    public void setRestartOn(String restartOn) {
        this.restartOn = restartOn;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public long getInstanceId() {
        return this.jobInstance.getInstanceId();
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public ModelNavigator<JSLJob> getJobNavigator() {
        return this.jobNavigator;
    }

    public JobContextImpl getJobContext() {
        return this.jobContext;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public InternalJobExecution getJobOperatorJobExecution() {
        return this.operatorJobExecution;
    }

    public BatchStatus getBatchStatus() {
        return this.jobContext.getBatchStatus();
    }

    public String getExitStatus() {
        return this.jobContext.getExitStatus();
    }

    public void setBatchStatus(String status) {
        this.operatorJobExecution.setBatchStatus(status);
    }

    public void setCreateTime(Timestamp ts) {
        this.operatorJobExecution.setCreateTime(ts);
    }

    public void setEndTime(Timestamp ts) {
        this.operatorJobExecution.setEndTime(ts);
    }

    public void setExitStatus(String status) {
        this.operatorJobExecution.setExitStatus(status);
    }

    public void setLastUpdateTime(Timestamp ts) {
        this.operatorJobExecution.setLastUpdateTime(ts);
    }

    public void setStartTime(Timestamp ts) {
        this.operatorJobExecution.setStartTime(ts);
    }

    public void setJobParameters(Properties jProps) {
        this.operatorJobExecution.setJobParameters(jProps);
    }

    public Properties getJobParameters() {
        return this.operatorJobExecution.getJobParameters();
    }

    public Date getStartTime() {
        return this.operatorJobExecution.getStartTime();
    }

    public Date getEndTime() {
        return this.operatorJobExecution.getEndTime();
    }

    public Date getLastUpdatedTime() {
        return this.operatorJobExecution.getLastUpdatedTime();
    }

    public Date getCreateTime() {
        return this.operatorJobExecution.getCreateTime();
    }

    public String toString() {
        return " executionId: " + this.executionId + " restartOn: " + this.restartOn + "\n-----------------------\njobInstance: \n   " + this.jobInstance;
    }

    public Integer getPartitionInstance() {
        return this.partitionInstance;
    }

    public void setPartitionInstance(Integer partitionInstance) {
        this.partitionInstance = partitionInstance;
    }

    public Collection<Closeable> getReleasables() {
        return this.releasables;
    }

    public synchronized void addReleasable(Closeable releasable) {
        this.releasables.add(releasable);
    }
}

