/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.ThreadRootController;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.JobController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.ServicesManager;

public class BatchWorkUnit
implements Runnable {
    protected RuntimeJobExecution jobExecutionImpl = null;
    protected BatchKernelService batchKernel = null;
    protected ThreadRootController controller;
    protected boolean notifyCallbackWhenDone;

    public BatchWorkUnit(ServicesManager manager, RuntimeJobExecution jobExecutionImpl) {
        this(manager, jobExecutionImpl, true);
    }

    public BatchWorkUnit(ServicesManager manager, RuntimeJobExecution jobExecutionImpl, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(manager.service(BatchKernelService.class));
        this.setJobExecutionImpl(jobExecutionImpl);
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new JobController(jobExecutionImpl, manager);
    }

    public ThreadRootController getController() {
        return this.controller;
    }

    @Override
    public void run() {
        try {
            this.controller.originateExecutionOnThread();
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
        }
        catch (Throwable t) {
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", t);
        }
        finally {
            this.markThreadCompleted();
        }
    }

    protected BatchStatus getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    protected String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(BatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public BatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobExecution jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobExecution getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    protected void markThreadCompleted() {
    }
}

