/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.container.Init;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.spi.JobExecutionCallbackService;
import org.apache.batchee.spi.JobXMLLoaderService;
import org.apache.batchee.spi.PersistenceManagerService;

public class JobOperatorImpl
implements JobOperator {
    private static final Logger LOGGER = Logger.getLogger(JobOperatorImpl.class.getName());
    private final BatchKernelService kernelService;
    private final PersistenceManagerService persistenceManagerService;
    private final JobXMLLoaderService xmlLoaderService;
    private final JobStatusManagerService statusManagerService;
    private final JobExecutionCallbackService callbackService;

    protected JobOperatorImpl(ServicesManager servicesManager) {
        try {
            this.kernelService = servicesManager.service(BatchKernelService.class);
            this.persistenceManagerService = servicesManager.service(PersistenceManagerService.class);
            this.xmlLoaderService = servicesManager.service(JobXMLLoaderService.class);
            this.statusManagerService = servicesManager.service(JobStatusManagerService.class);
            this.callbackService = servicesManager.service(JobExecutionCallbackService.class);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Error while booting BatchEE", e);
            throw e;
        }
    }

    public JobOperatorImpl() {
        this(ServicesManager.find());
    }

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        try {
            return this.startInternal(jobXMLName, jobParameters);
        }
        catch (JobSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobStartException((Throwable)e);
        }
    }

    private long startInternal(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        StringWriter jobParameterWriter = new StringWriter();
        if (jobParameters != null) {
            try {
                jobParameters.store(jobParameterWriter, "Job parameters on start: ");
            }
            catch (IOException e) {
                jobParameterWriter.write("Job parameters on start: not printable");
            }
        } else {
            jobParameterWriter.write("Job parameters on start = null");
        }
        String jobXML = this.xmlLoaderService.loadJSL(jobXMLName);
        InternalJobExecution execution = this.kernelService.startJob(jobXML, jobParameters);
        return execution.getExecutionId();
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        InternalJobExecution jobEx = this.persistenceManagerService.jobOperatorGetJobExecution(executionId);
        BatchStatus status = jobEx.getBatchStatus();
        if (status == BatchStatus.STARTING || status == BatchStatus.STARTED) {
            throw new JobExecutionIsRunningException("Job Execution: " + executionId + " is still running");
        }
        this.persistenceManagerService.updateBatchStatusOnly(jobEx.getExecutionId(), BatchStatus.ABANDONED, new Timestamp(System.currentTimeMillis()));
        this.statusManagerService.updateJobBatchStatus(jobEx.getInstanceId(), BatchStatus.ABANDONED);
    }

    public InternalJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.kernelService.getJobExecution(executionId);
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        List<InternalJobExecution> executionImpls = this.persistenceManagerService.jobOperatorGetJobExecutions(instance.getInstanceId());
        if (executionImpls.size() == 0) {
            throw new NoSuchJobInstanceException("Job: " + instance.getJobName() + " does not exist");
        }
        for (InternalJobExecution e : executionImpls) {
            executions.add(e);
        }
        return executions;
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.kernelService.getJobInstance(executionId);
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        int jobInstanceCount = this.persistenceManagerService.jobOperatorGetJobInstanceCount(jobName);
        if (jobInstanceCount > 0) {
            return jobInstanceCount;
        }
        throw new NoSuchJobException("Job " + jobName + " not found");
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        if (count == 0) {
            return new ArrayList<JobInstance>();
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count should be a positive integer (or 0, which will return an empty list)");
        }
        List<Long> instanceIds = this.persistenceManagerService.jobOperatorGetJobInstanceIds(jobName, start, count);
        if (instanceIds.size() > 0) {
            for (long id : instanceIds) {
                JobStatus jobStatus = this.statusManagerService.getJobStatus(id);
                JobInstanceImpl jobInstance = jobStatus.getJobInstance();
                jobInstances.add(jobInstance);
            }
            return jobInstances;
        }
        throw new NoSuchJobException("Job Name " + jobName + " not found");
    }

    public Set<String> getJobNames() throws JobSecurityException {
        return new HashSet<String>(this.persistenceManagerService.getJobNames());
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobInstance requestedJobInstance = this.kernelService.getJobInstance(executionId);
        return this.persistenceManagerService.getParameters(executionId);
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        ArrayList<Long> jobExecutions = new ArrayList<Long>();
        Set<Long> executionIds = this.persistenceManagerService.jobOperatorGetRunningExecutions(jobName);
        if (executionIds.isEmpty()) {
            throw new NoSuchJobException("Job Name " + jobName + " not found");
        }
        for (long id : executionIds) {
            try {
                if (!this.kernelService.isExecutionRunning(id)) continue;
                InternalJobExecution jobEx = this.kernelService.getJobExecution(id);
                jobExecutions.add(jobEx.getExecutionId());
            }
            catch (NoSuchJobExecutionException e) {
                throw new IllegalStateException("Just found execution with id = " + id + " in table, but now seeing it as gone", e);
            }
        }
        return jobExecutions;
    }

    public List<StepExecution> getStepExecutions(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        InternalJobExecution jobEx = this.kernelService.getJobExecution(executionId);
        if (jobEx == null) {
            throw new NoSuchJobExecutionException("Job Execution: " + executionId + " not found");
        }
        return this.persistenceManagerService.getStepExecutionsForJobExecution(executionId);
    }

    public long restart(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        try {
            return this.restartInternal(oldExecutionId, restartParameters);
        }
        catch (JobExecutionAlreadyCompleteException e) {
            throw e;
        }
        catch (NoSuchJobExecutionException e) {
            throw e;
        }
        catch (JobExecutionNotMostRecentException e) {
            throw e;
        }
        catch (JobSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobRestartException((Throwable)e);
        }
    }

    private long restartInternal(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        StringWriter jobParameterWriter = new StringWriter();
        if (restartParameters != null) {
            try {
                restartParameters.store(jobParameterWriter, "Job parameters on restart: ");
            }
            catch (IOException e) {
                jobParameterWriter.write("Job parameters on restart: not printable");
            }
        } else {
            jobParameterWriter.write("Job parameters on restart = null");
        }
        return this.kernelService.restartJob(oldExecutionId, restartParameters).getExecutionId();
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.kernelService.stopJob(executionId);
    }

    public void waitFor(long id) {
        this.callbackService.waitFor(this, id);
    }

    static {
        Init.doInit();
    }
}

