/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public final class Jacksons {
    public static ObjectMapper newMapper(String config) {
        ObjectMapper mapper = new ObjectMapper();
        if (config != null) {
            String deserializationName = DeserializationFeature.class.getSimpleName();
            String serializationName = SerializationFeature.class.getSimpleName();
            String mapperName = MapperFeature.class.getSimpleName();
            for (String conf : config.split(",")) {
                String[] parts = conf.split("=");
                parts[0] = parts[0].trim();
                parts[1] = parts[1].trim();
                if (parts[0].startsWith(deserializationName)) {
                    mapper.configure(DeserializationFeature.valueOf((String)parts[0].substring(deserializationName.length() + 1)), Boolean.parseBoolean(parts[1]));
                    continue;
                }
                if (parts[0].startsWith(serializationName)) {
                    mapper.configure(SerializationFeature.valueOf((String)parts[0].substring(serializationName.length() + 1)), Boolean.parseBoolean(parts[1]));
                    continue;
                }
                if (parts[0].startsWith(mapperName)) {
                    mapper.configure(MapperFeature.valueOf((String)parts[0].substring(mapperName.length() + 1)), Boolean.parseBoolean(parts[1]));
                    continue;
                }
                throw new IllegalArgumentException("Ignored config: " + conf);
            }
        }
        return mapper;
    }

    private Jacksons() {
    }
}

