/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.locator;

import java.io.Closeable;
import java.lang.reflect.Method;
import javax.batch.operations.BatchRuntimeException;
import org.apache.batchee.extras.locator.BeanLocator;

public class BatcheeLocator
implements BeanLocator {
    public static final BeanLocator INSTANCE = new BatcheeLocator();
    private Method getValue = null;
    private Method getReleasable = null;
    private Method instantiationMethod = null;
    private Object delegate = null;

    private BatcheeLocator() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> service = loader.loadClass("org.apache.batchee.spi.BatchArtifactFactory");
            this.instantiationMethod = service.getMethod("load", String.class);
            Class<?> returnType = loader.loadClass("org.apache.batchee.spi.BatchArtifactFactory$Instance");
            this.getValue = returnType.getMethod("getValue", new Class[0]);
            this.getReleasable = returnType.getMethod("getReleasable", new Class[0]);
            Class<?> clazz = loader.loadClass("org.apache.batchee.container.services.factory.CDIBatchArtifactFactory");
            this.delegate = clazz.newInstance();
        }
        catch (Throwable th) {
            try {
                Class<?> clazz = loader.loadClass("org.apache.batchee.container.services.factory.DefaultBatchArtifactFactory");
                this.delegate = clazz.newInstance();
            }
            catch (Throwable th2) {
                this.delegate = null;
                this.instantiationMethod = null;
            }
        }
    }

    @Override
    public <T> BeanLocator.LocatorInstance<T> newInstance(Class<T> expected, String batchId) {
        if (this.delegate == null) {
            return null;
        }
        try {
            Object result = this.instantiationMethod.invoke(this.delegate, batchId);
            return new BeanLocator.LocatorInstance<T>(expected.cast(this.getValue.invoke(result, new Object[0])), (Closeable)Closeable.class.cast(this.getReleasable.invoke(result, new Object[0])));
        }
        catch (Exception e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }
}

