/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.csv;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.apache.batchee.csv.CSVFormatFactory;
import org.apache.batchee.csv.CsvReaderMapper;
import org.apache.batchee.csv.mapper.DefaultMapper;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.buffered.IteratorReader;
import org.apache.batchee.extras.locator.BeanLocator;
import org.apache.batchee.extras.transaction.CountedReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@Documentation(value="Reads a CSV file using commons-csv.")
public class CommonsCsvReader
extends CountedReader {
    private static final CsvReaderMapper<CSVRecord> NOOP_MAPPER = new CsvReaderMapper<CSVRecord>(){

        @Override
        public CSVRecord fromRecord(CSVRecord record) {
            return record;
        }
    };
    @Inject
    @BatchProperty
    @Documentation(value="format to use (Default, RFC4180, Excel, TDF, MySQL)")
    private String format;
    @Inject
    @BatchProperty
    @Documentation(value="file to read")
    private String input;
    @Inject
    @BatchProperty
    @Documentation(value="input encoding")
    private String encoding;
    @Inject
    @BatchProperty
    @Documentation(value="record mapper if mapping is null")
    private String mapper;
    @Inject
    @BatchProperty
    @Documentation(value="mapping type if mapper is null")
    private String mapping;
    @Inject
    @BatchProperty
    @Documentation(value="locator to lookup the mapper")
    private String locator;
    @Inject
    @BatchProperty
    @Documentation(value="is missing column names allowed")
    private String allowMissingColumnNames;
    @Inject
    @BatchProperty
    @Documentation(value="delimiter of the file")
    private String delimiter;
    @Inject
    @BatchProperty
    @Documentation(value="quote character")
    private String quoteCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="quote mode (ALL, MINIMAL, NON_NUMERIC, NONE)")
    private String quoteMode;
    @Inject
    @BatchProperty
    @Documentation(value="comment marker")
    private String commentMarker;
    @Inject
    @BatchProperty
    @Documentation(value="escape character")
    private String escapeCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="should the parser ignore surrounding spaces")
    private String ignoreSurroundingSpaces;
    @Inject
    @BatchProperty
    @Documentation(value="should empty lines be skipped")
    private String ignoreEmptyLines;
    @Inject
    @BatchProperty
    @Documentation(value="record separator")
    private String recordSeparator;
    @Inject
    @BatchProperty
    @Documentation(value="string replacement for null")
    private String nullString;
    @Inject
    @BatchProperty
    @Documentation(value="header comments")
    private String headerComments;
    @Inject
    @BatchProperty
    @Documentation(value="headers")
    private String header;
    @Inject
    @BatchProperty
    @Documentation(value="should headers be skipped")
    private String skipHeaderRecord;
    @Inject
    @BatchProperty
    @Documentation(value="should headers be used")
    private String readHeaders;
    private IteratorReader<CSVRecord> iterator;
    private CSVParser parser;
    private BeanLocator.LocatorInstance<CsvReaderMapper> mapperInstance;

    public void open(Serializable checkpoint) throws Exception {
        CSVFormat csvFormat = this.newFormat();
        this.parser = csvFormat.parse(this.newReader());
        this.iterator = new IteratorReader(this.parser.iterator());
        this.mapperInstance = this.mapper == null ? new BeanLocator.LocatorInstance((Object)(this.mapping != null ? new DefaultMapper(Thread.currentThread().getContextClassLoader().loadClass(this.mapping)) : NOOP_MAPPER), null) : BeanLocator.Finder.get((String)this.locator).newInstance(CsvReaderMapper.class, this.mapper);
        super.open(checkpoint);
    }

    protected Object doRead() throws Exception {
        CSVRecord read = (CSVRecord)this.iterator.read();
        return read != null ? ((CsvReaderMapper)this.mapperInstance.getValue()).fromRecord(read) : null;
    }

    public void close() throws Exception {
        this.mapperInstance.release();
        if (this.parser != null) {
            this.parser.close();
        }
    }

    protected Reader newReader() {
        try {
            return this.encoding != null ? new InputStreamReader((InputStream)new FileInputStream(this.input), this.encoding) : new FileReader(this.input);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected CSVFormat newFormat() {
        return CSVFormatFactory.newFormat(this.format, this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.readHeaders);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFormat(CSVFormat.Predefined predefined) {
        this.format = predefined.name();
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public void setAllowMissingColumnNames(String allowMissingColumnNames) {
        this.allowMissingColumnNames = allowMissingColumnNames;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setQuoteMode(String quoteMode) {
        this.quoteMode = quoteMode;
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public void setIgnoreSurroundingSpaces(String ignoreSurroundingSpaces) {
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
    }

    public void setIgnoreEmptyLines(String ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public void setHeaderComments(String headerComments) {
        this.headerComments = headerComments;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setSkipHeaderRecord(String skipHeaderRecord) {
        this.skipHeaderRecord = skipHeaderRecord;
    }

    public void setReadHeaders(String readHeaders) {
        this.readHeaders = readHeaders;
    }

    public void readHeaders() {
        this.readHeaders = "true";
    }
}

