/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChildFirstURLClassLoader
extends URLClassLoader {
    private final ClassLoader system;
    private final Collection<File> resources = new CopyOnWriteArrayList<File>();
    private File applicationFolder;

    public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.system = ClassLoader.getSystemClassLoader();
    }

    public void addResource(File resource) {
        if (resource.isDirectory()) {
            this.resources.add(resource);
        }
    }

    @Override
    public URL findResource(String name) {
        try {
            Collection<URL> urls = this.findResourceUrls(name, name);
            if (urls != null) {
                return urls.iterator().next();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> defaultResources = super.findResources(name);
        if (name == null) {
            return defaultResources;
        }
        Collection<URL> urls = this.findResourceUrls(name, name);
        if (urls != null) {
            urls.addAll(Collections.list(defaultResources));
            return Collections.enumeration(urls);
        }
        return defaultResources;
    }

    private Collection<URL> findResourceUrls(String inName, String nameWithoutSlash) throws MalformedURLException {
        String name = inName.startsWith("/") && inName.length() > 1 ? inName.substring(1) : inName;
        LinkedList<URL> urls = null;
        if ((name.startsWith("META-INF/batch-jobs/") || name.endsWith("batch.xml") || name.endsWith("batchee.xml")) && nameWithoutSlash.endsWith(".xml")) {
            for (File folder : this.resources) {
                File resource = new File(folder, nameWithoutSlash.replace("META-INF/", ""));
                if (!resource.isFile()) continue;
                if (urls == null) {
                    urls = new LinkedList<URL>();
                }
                urls.add(resource.toURI().toURL());
            }
        }
        return urls;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            try {
                clazz = this.system.loadClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            clazz = this.loadInternal(name, resolve);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.loadFromParent(name, resolve);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
    }

    private Class<?> loadFromParent(String name, boolean resolve) {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = this.system;
        }
        try {
            Class<?> clazz = Class.forName(name, false, parent);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Class<?> loadInternal(String name, boolean resolve) {
        try {
            Class<?> clazz = this.findClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void setApplicationFolder(File applicationFolder) {
        this.applicationFolder = applicationFolder;
    }

    public File getApplicationFolder() {
        return this.applicationFolder;
    }

    public void addUrls(Collection<URL> urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }
}

