/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.batchee.cli.command.api.CliConfiguration;
import org.apache.batchee.cli.command.api.UserCommand;

public class DefaultCliConfiguration
implements CliConfiguration {
    @Override
    public String name() {
        return "batchee";
    }

    @Override
    public String description() {
        return "BatchEE CLI";
    }

    @Override
    public boolean addDefaultCommands() {
        return true;
    }

    @Override
    public Iterator<Class<? extends UserCommand>> userCommands() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = tccl != null ? tccl : ClassLoader.getSystemClassLoader();
            Enumeration<URL> uc = loader.getResources("META-INF/services/org.apache.batchee.cli.command.UserCommand");
            while (uc.hasMoreElements()) {
                URL url = uc.nextElement();
                BufferedReader r = null;
                try {
                    String line;
                    r = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((line = r.readLine()) != null) {
                        if (line.startsWith("#") || line.trim().isEmpty()) continue;
                        classes.add((Class)Class.class.cast(loader.loadClass(line.trim())));
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException(cnfe);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return classes.iterator();
    }

    @Override
    public Runnable decorate(Runnable task) {
        return task;
    }

    @Override
    public Object coerce(String value, Type expected) {
        if (String.class == expected) {
            return value;
        }
        if (Long.TYPE == expected) {
            return Long.parseLong(value);
        }
        if (Integer.TYPE == expected) {
            return Integer.parseInt(value);
        }
        if (Boolean.TYPE == expected) {
            return Boolean.parseBoolean(value);
        }
        if (Short.TYPE == expected) {
            return Short.parseShort(value);
        }
        if (Byte.TYPE == expected) {
            return Byte.parseByte(value);
        }
        if (Character.TYPE == expected) {
            return Character.valueOf(value.charAt(0));
        }
        if (Class.class.isInstance(expected)) {
            try {
                return ((Class)Class.class.cast(expected)).getMethod("fromString", String.class).invoke(null, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(expected + " not supported as option with value '" + value + "'");
    }
}

