/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.batchee.cli.command.api.Command;
import org.apache.batchee.cli.command.api.Option;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.spi.PersistenceManagerService;

@Command(name="evict", description="remove old data, uses embedded configuration (no JAXRS support yet)")
public class Eviction
implements Runnable {
    @Option(name="until", description="date until when the eviction will occur (excluded), YYYYMMDD format", required=true)
    private String date;

    @Override
    public void run() {
        try {
            Date date = new SimpleDateFormat("yyyyMMdd").parse(this.date);
            ((PersistenceManagerService)ServicesManager.find().service(PersistenceManagerService.class)).cleanUp(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

