/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobInstance;
import org.apache.batchee.cli.command.JobOperatorCommand;

@Command(name="instances", description="list instances")
public class Instances
extends JobOperatorCommand {
    @Option(name={"-name"}, description="name of the batch to start", required=true)
    private String name;
    @Option(name={"-start"}, description="start of the list of job instance to query")
    private int start = 0;
    @Option(name={"-count"}, description="number of instance to query")
    private int count = 100;

    @Override
    public void doRun() {
        JobOperator operator = this.operator();
        long total = operator.getJobInstanceCount(this.name);
        this.info(this.name + " has " + total + " job instances");
        this.info("");
        this.info("instance id");
        this.info("-----------");
        List id = operator.getJobInstances(this.name, this.start, this.count);
        if (id != null) {
            for (JobInstance instance : id) {
                this.info(Long.toString(instance.getInstanceId()));
            }
        }
    }
}

