/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.batch.runtime.BatchRuntime;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.batchee.cdi.impl.ContextResolver;
import org.apache.batchee.cdi.impl.DynamicContextResolver;
import org.apache.batchee.cdi.impl.ThreadLocalContextResolver;

public abstract class BaseContext
implements Context {
    protected final BeanManager bm;
    private ConcurrentMap<Long, ConcurrentMap<Contextual<?>, Instance<?>>> storages = new ConcurrentHashMap();
    private ContextResolver contextResolver;

    public BaseContext(BeanManager bm) {
        this.bm = bm;
    }

    protected abstract Long currentKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.checkActive();
        ConcurrentMap<Contextual<?>, Instance<?>> storage = this.getOrCreateCurrentStorage();
        Instance instance = (Instance)storage.get(component);
        if (instance == null) {
            BaseContext baseContext = this;
            synchronized (baseContext) {
                instance = (Instance)storage.get(component);
                if (instance == null) {
                    Object value = component.create(creationalContext);
                    instance = new Instance(value, creationalContext);
                    storage.putIfAbsent(component, instance);
                }
            }
        }
        return (T)instance.value;
    }

    public <T> T get(Contextual<T> component) {
        this.checkActive();
        ConcurrentMap storage = (ConcurrentMap)this.storages.get(this.currentKey());
        if (storage != null) {
            Instance instance = (Instance)storage.get(component);
            if (instance == null) {
                return null;
            }
            return (T)instance.value;
        }
        return null;
    }

    public boolean isActive() {
        return this.currentKey() != null;
    }

    public void endContext(Long key) {
        ConcurrentMap storage = (ConcurrentMap)this.storages.remove(key);
        if (storage == null) {
            return;
        }
        for (Map.Entry entry : storage.entrySet()) {
            Instance instance = (Instance)entry.getValue();
            ((Contextual)Contextual.class.cast(entry.getKey())).destroy(instance.value, instance.cc);
        }
        storage.clear();
    }

    protected ContextResolver getContextResolver() {
        if (this.contextResolver == null) {
            this.contextResolver = BatchRuntime.getJobOperator().getClass().getName().contains("batchee") ? new ThreadLocalContextResolver() : new DynamicContextResolver(this.bm);
        }
        return this.contextResolver;
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    private ConcurrentMap<Contextual<?>, Instance<?>> getOrCreateCurrentStorage() {
        ConcurrentMap existing;
        Long key = this.currentKey();
        ConcurrentMap storage = (ConcurrentHashMap)this.storages.get(key);
        if (storage == null && (existing = (ConcurrentMap)this.storages.putIfAbsent(key, storage = new ConcurrentHashMap())) != null) {
            storage = existing;
        }
        return storage;
    }

    private static class Instance<T> {
        private final T value;
        private final CreationalContext<T> cc;

        private Instance(T value, CreationalContext<T> context) {
            this.value = value;
            this.cc = context;
        }
    }
}

