/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.camel.component;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;

public class JBatchProducer
extends DefaultProducer {
    public static final String JBATCH_EXECUTION_ID = "JBatchExecutionId";
    public static final String JBATCH_OPERATOR = "JBatchOperator";
    private final JobOperator operator;
    private final String jobName;
    private final int synchronous;
    private final boolean restart;
    private final boolean stop;
    private final boolean abandon;

    public JBatchProducer(Endpoint jBatchEndpoint, JobOperator operator, String job, int synchronous, boolean restart, boolean stop, boolean abandon) {
        super(jBatchEndpoint);
        this.operator = operator;
        this.jobName = job;
        this.synchronous = synchronous;
        this.restart = restart;
        this.stop = stop;
        this.abandon = abandon;
    }

    public void process(Exchange exchange) throws Exception {
        long id;
        if (this.stop) {
            long stopId = (Long)exchange.getIn().getHeader(JBATCH_EXECUTION_ID, Long.class);
            this.operator.stop(stopId);
            return;
        }
        if (this.abandon) {
            long abandonId = (Long)exchange.getIn().getHeader(JBATCH_EXECUTION_ID, Long.class);
            this.operator.abandon(abandonId);
            return;
        }
        if (this.restart) {
            long restartId = (Long)exchange.getIn().getHeader(JBATCH_EXECUTION_ID, Long.class);
            id = this.operator.restart(restartId, JBatchProducer.toProperties(exchange.getIn().getHeaders()));
        } else {
            id = this.operator.start(this.jobName, JBatchProducer.toProperties(exchange.getIn().getHeaders()));
        }
        exchange.getIn().setHeader(JBATCH_EXECUTION_ID, (Object)id);
        exchange.getIn().setHeader(JBATCH_OPERATOR, (Object)this.operator);
        if (this.synchronous > 0) {
            List<BatchStatus> endStatuses = Arrays.asList(BatchStatus.COMPLETED, BatchStatus.FAILED);
            do {
                try {
                    Thread.sleep(this.synchronous);
                }
                catch (InterruptedException e) {
                    return;
                }
            } while (!endStatuses.contains(this.operator.getJobExecution(id).getBatchStatus()));
        }
    }

    private static Properties toProperties(Map<String, Object> headers) {
        Properties parametersBuilder = new Properties();
        for (Map.Entry<String, Object> headerEntry : headers.entrySet()) {
            String headerKey = headerEntry.getKey();
            Object headerValue = headerEntry.getValue();
            if (headerValue != null) {
                parametersBuilder.setProperty(headerKey, headerValue.toString());
                continue;
            }
            parametersBuilder.setProperty(headerKey, "");
        }
        return parametersBuilder;
    }
}

