/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.camel;

import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Inject;
import org.apache.batchee.camel.CamelBridge;
import org.apache.batchee.doc.api.Documentation;

@Documentation(value="Uses camel producer template to process the incoming item.")
public class CamelItemProcessor
implements ItemProcessor {
    @Inject
    @BatchProperty
    @Documentation(value="Endpoint URI")
    private String endpoint;
    @Inject
    @BatchProperty
    @Documentation(value="The locator to use to find the producer template")
    private String templateLocator;

    public Object processItem(Object item) throws Exception {
        return CamelBridge.process(this.templateLocator, this.endpoint, item);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setLocator(String locator) {
        this.templateLocator = locator;
    }
}

