/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.wsdl2code;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.maven.shared.NamespaceMapping;
import org.apache.axis2.maven.shared.NamespaceMappingUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWSDL2CodeMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="axis2.wsdl2code.wsdlFile", defaultValue="src/main/resources/service.wsdl")
    private String wsdlFile;
    @Parameter(property="axis2.wsdl2code.package")
    private String packageName;
    @Parameter(property="axis2.wsdl2code.language", defaultValue="java")
    private String language;
    @Parameter(property="axis2.wsdl2code.databindingName", defaultValue="adb")
    private String databindingName;
    @Parameter(property="axis2.wsdl2code.jibxBindingFile")
    private String jibxBindingFile;
    @Parameter(property="axis2.wsdl2code.portName")
    private String portName;
    @Parameter(property="axis2.wsdl2code.serviceName")
    private String serviceName;
    @Parameter(property="axis2.wsdl2code.syncMode", defaultValue="both")
    private String syncMode;
    @Parameter(property="axis2.wsdl2code.generateServerSide", defaultValue="false")
    private boolean generateServerSide;
    @Parameter(property="axis2.wsdl2code.generateTestCase", defaultValue="false")
    private boolean generateTestcase;
    @Parameter(property="axis2.wsdl2code.generateServicesXml", defaultValue="false")
    private boolean generateServicesXml;
    @Parameter(property="axis2.wsdl2code.generateAllClasses", defaultValue="false")
    private boolean generateAllClasses;
    @Parameter(property="axis2.wsdl2code.unpackClasses", defaultValue="false")
    private boolean unpackClasses;
    @Parameter(property="axis2.wsdl2code.generateServerSideInterface", defaultValue="false")
    private boolean generateServerSideInterface = false;
    @Parameter(property="axis2.wsdl2code.repositoryPath")
    private String repositoryPath = null;
    @Parameter(property="axis2.wsdl2code.externalMapping")
    private File externalMapping = null;
    @Parameter(property="axis2.wsdl2code.wsdlVersion", defaultValue="1.1")
    private String wsdlVersion;
    @Parameter(property="axis2.wsdl2code.targetSourceFolderLocation", defaultValue="src")
    private String targetSourceFolderLocation;
    @Parameter(property="axis2.wsdl2code.targetResourcesFolderLocation")
    private String targetResourcesFolderLocation = null;
    @Parameter(property="axis2.wsdl2code.unwrap", defaultValue="false")
    private boolean unwrap = false;
    @Parameter(property="axis2.wsdl2code.allPorts", defaultValue="false")
    private boolean allPorts = false;
    @Parameter(property="axis2.wsdl2code.backwardCompatible", defaultValue="false")
    private boolean backwardCompatible = false;
    @Parameter(property="axis2.wsdl2code.flattenFiles", defaultValue="false")
    private boolean flattenFiles = false;
    @Parameter(property="axis2.wsdl2code.skipMessageReceiver", defaultValue="false")
    private boolean skipMessageReceiver = false;
    @Parameter(property="axis2.wsdl2code.skipBuildXML", defaultValue="false")
    private boolean skipBuildXML = false;
    @Parameter(property="axis2.wsdl2code.skipWSDL", defaultValue="false")
    private boolean skipWSDL = false;
    @Parameter(property="axis2.wsdl2code.overWrite", defaultValue="false")
    private boolean overWrite = false;
    @Parameter(property="axis2.wsdl2code.suppressPrefixes", defaultValue="false")
    private boolean suppressPrefixes = false;
    @Parameter(property="axis2.java2wsdl.options")
    private Properties options;
    @Parameter(property="axis2.wsdl2code.namespaceToPackages")
    private String namespaceToPackages = null;
    @Parameter
    private NamespaceMapping[] namespaceMappings;
    @Parameter
    private NamespaceMapping[] namespaceURIs = null;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="axis2.wsdl2code.skeletonInterfaceName")
    private String skeletonInterfaceName;
    @Parameter(property="axis2.wsdl2code.skeletonClassName")
    private String skeletonClassName;

    private CodeGenConfiguration buildConfiguration() throws CodeGenerationException, MojoFailureException {
        File file;
        CodeGenConfiguration config = new CodeGenConfiguration();
        if (this.wsdlFile.indexOf(":") == -1 && !(file = new File(this.wsdlFile)).isAbsolute()) {
            this.wsdlFile = String.valueOf(this.project.getBasedir()) + File.separator + this.wsdlFile;
        }
        config.setOutputLocation(this.getOutputDirectory());
        config.setDatabindingType(this.databindingName);
        if ("jibx".equals(this.databindingName)) {
            config.getProperties().put("bindingfile", this.jibxBindingFile);
        }
        if ("async".equals(this.syncMode)) {
            config.setSyncOn(false);
            config.setAsyncOn(true);
        } else if ("sync".equals(this.syncMode)) {
            config.setSyncOn(true);
            config.setAsyncOn(false);
        } else if ("both".equals(this.syncMode)) {
            config.setSyncOn(true);
            config.setAsyncOn(true);
        } else {
            throw new MojoFailureException("Invalid syncMode: " + this.syncMode + ", expected either of 'sync', 'async' or 'both'.");
        }
        config.setPackageName(this.packageName);
        config.setOutputLanguage(this.language);
        config.setServerSide(this.generateServerSide);
        config.setGenerateDeployementDescriptor(this.generateServicesXml);
        config.setGenerateAll(this.generateAllClasses);
        config.setWriteTestCase(this.generateTestcase);
        config.setPackClasses(!this.unpackClasses);
        config.setServerSideInterface(this.generateServerSideInterface);
        config.setParametersWrapped(!this.unwrap);
        config.setAllPorts(this.allPorts);
        config.setBackwordCompatibilityMode(this.backwardCompatible);
        config.setFlattenFiles(this.flattenFiles);
        config.setSkipMessageReceiver(this.skipMessageReceiver);
        config.setSkipBuildXML(this.skipBuildXML);
        config.setSkipWriteWSDLs(this.skipWSDL);
        config.setOverride(this.overWrite);
        config.setSuppressPrefixesMode(this.suppressPrefixes);
        config.setRepositoryPath(this.repositoryPath);
        config.setTypeMappingFile(this.externalMapping);
        config.setWSDLVersion(this.wsdlVersion);
        config.setSourceLocation(this.targetSourceFolderLocation);
        if (this.targetResourcesFolderLocation != null) {
            config.setResourceLocation(this.targetResourcesFolderLocation);
        }
        if (this.options != null) {
            config.getProperties().putAll(this.options);
        }
        config.setServiceName(this.serviceName);
        config.setPortName(this.portName);
        config.setUri2PackageNameMap(this.getNamespaceToPackagesMap());
        config.setOutputEncoding(this.encoding);
        config.setSkeltonInterfaceName(this.skeletonInterfaceName);
        config.setSkeltonClassName(this.skeletonClassName);
        config.loadWsdl(this.wsdlFile);
        return config;
    }

    private Map<String, String> getNamespaceToPackagesMap() throws MojoFailureException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.namespaceToPackages != null) {
            for (String pair : this.namespaceToPackages.trim().split(",")) {
                String[] values = pair.split("=");
                map.put(values[0].trim(), values[1].trim());
            }
        }
        NamespaceMappingUtil.addToMap((NamespaceMapping[])this.namespaceURIs, map);
        NamespaceMappingUtil.addToMap((NamespaceMapping[])this.namespaceMappings, map);
        return map;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        File outputDirectory = this.getOutputDirectory();
        outputDirectory.mkdirs();
        this.addSourceRoot(this.project, new File(outputDirectory, this.targetSourceFolderLocation));
        try {
            new CodeGenerationEngine(this.buildConfiguration()).generate();
        }
        catch (CodeGenerationException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected abstract File getOutputDirectory();

    protected abstract void addSourceRoot(MavenProject var1, File var2);
}

