/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.wsdl2code;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.maven2.wsdl2code.NamespaceURIMapping;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2CodeMojo
extends AbstractMojo {
    private MavenProject project;
    private String wsdlFile;
    private File outputDirectory;
    private String packageName;
    private String language;
    private String databindingName;
    private String jibxBindingFile;
    private String portName;
    private String serviceName;
    private String syncMode;
    private boolean generateServerSide;
    private boolean generateTestcase;
    private boolean generateServicesXml;
    private boolean generateAllClasses;
    private boolean unpackClasses;
    private boolean generateServerSideInterface = false;
    private String repositoryPath = null;
    private String externalMapping = null;
    private String wsdlVersion = null;
    private String targetSourceFolderLocation;
    private String targetResourcesFolderLocation = null;
    private boolean unwrap = false;
    private boolean allPorts = false;
    private boolean backwardCompatible = false;
    private boolean flattenFiles = false;
    private boolean skipMessageReceiver = false;
    private boolean skipBuildXML = false;
    private boolean skipWSDL = false;
    private boolean overWrite = false;
    private boolean suppressPrefixes = false;
    private Properties options;
    private String namespaceToPackages = null;
    private NamespaceURIMapping[] namespaceURIs = null;
    private String httpProxyHost = null;
    private String httpProxyPort = null;
    private String httpProxyUser = null;
    private String httpProxyPassword = null;

    private Map<String, CommandLineOption> fillOptionMap() throws MojoFailureException {
        File file;
        HashMap<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
        if (this.wsdlFile.indexOf(":") == -1 && !(file = new File(this.wsdlFile)).isAbsolute()) {
            this.wsdlFile = this.project.getBasedir() + File.separator + this.wsdlFile;
        }
        optionMap.put("uri", new CommandLineOption("uri", this.getStringArray(this.wsdlFile)));
        optionMap.put("o", new CommandLineOption("o", this.getStringArray(this.outputDirectory.getPath())));
        optionMap.put("d", new CommandLineOption("d", this.getStringArray(this.databindingName)));
        if ("jibx".equals(this.databindingName)) {
            String key = "Ebindingfile";
            optionMap.put(key, new CommandLineOption(key, this.getStringArray(this.jibxBindingFile)));
        }
        if ("async".equals(this.syncMode)) {
            optionMap.put("a", new CommandLineOption("a", new String[0]));
        } else if ("sync".equals(this.syncMode)) {
            optionMap.put("s", new CommandLineOption("s", new String[0]));
        } else if (!"both".equals(this.syncMode)) {
            throw new MojoFailureException("Invalid syncMode: " + this.syncMode + ", expected either of 'sync', 'async' or 'both'.");
        }
        optionMap.put("p", new CommandLineOption("p", this.getStringArray(this.packageName)));
        optionMap.put("l", new CommandLineOption("l", this.getStringArray(this.language)));
        if (this.generateServerSide) {
            optionMap.put("ss", new CommandLineOption("ss", new String[0]));
            if (this.generateServicesXml) {
                optionMap.put("sd", new CommandLineOption("sd", new String[0]));
            }
            if (this.generateAllClasses) {
                optionMap.put("g", new CommandLineOption("g", new String[0]));
            }
        }
        if (this.generateTestcase) {
            optionMap.put("t", new CommandLineOption("t", new String[0]));
        }
        if (this.unpackClasses) {
            optionMap.put("u", new CommandLineOption("u", new String[0]));
        }
        if (this.generateServerSideInterface) {
            optionMap.put("ssi", new CommandLineOption("ssi", new String[0]));
        }
        if (this.unwrap) {
            optionMap.put("uw", new CommandLineOption("uw", new String[0]));
        }
        if (this.allPorts) {
            optionMap.put("ap", new CommandLineOption("ap", new String[0]));
        }
        if (this.backwardCompatible) {
            optionMap.put("b", new CommandLineOption("b", new String[0]));
        }
        if (this.flattenFiles) {
            optionMap.put("f", new CommandLineOption("f", new String[0]));
        }
        if (this.skipMessageReceiver) {
            optionMap.put("noMessageReceiver", new CommandLineOption("noMessageReceiver", new String[0]));
        }
        if (this.skipBuildXML) {
            optionMap.put("noBuildXML", new CommandLineOption("noBuildXML", new String[0]));
        }
        if (this.skipWSDL) {
            optionMap.put("noWSDL", new CommandLineOption("noWSDL", new String[0]));
        }
        if (this.overWrite) {
            optionMap.put("or", new CommandLineOption("or", new String[0]));
        }
        if (this.suppressPrefixes) {
            optionMap.put("sp", new CommandLineOption("sp", new String[0]));
        }
        if (this.repositoryPath != null) {
            optionMap.put("r", new CommandLineOption("r", new String[]{this.repositoryPath}));
        }
        if (this.externalMapping != null) {
            optionMap.put("em", new CommandLineOption("em", new String[]{this.externalMapping}));
        }
        if (this.wsdlVersion != null) {
            optionMap.put("wv", new CommandLineOption("wv", new String[]{this.wsdlVersion}));
        }
        optionMap.put("S", new CommandLineOption("S", new String[]{this.targetSourceFolderLocation}));
        if (this.targetResourcesFolderLocation != null) {
            optionMap.put("R", new CommandLineOption("R", new String[]{this.targetResourcesFolderLocation}));
        }
        if (this.options != null) {
            for (Map.Entry<Object, Object> entry : this.options.entrySet()) {
                String key = "E" + entry.getKey();
                String value = (String)entry.getValue();
                optionMap.put(key, new CommandLineOption(key, new String[]{value}));
            }
        }
        optionMap.put("sn", new CommandLineOption("sn", new String[]{this.serviceName}));
        optionMap.put("pn", new CommandLineOption("pn", new String[]{this.portName}));
        if (this.namespaceToPackages != null || this.namespaceURIs != null) {
            optionMap.put("ns2p", new CommandLineOption("ns2p", new String[]{this.getNamespaceToPackagesMap()}));
        }
        if (this.httpProxyHost != null) {
            optionMap.put("http-proxy-host", new CommandLineOption("http-proxy-host", new String[]{this.httpProxyHost}));
        }
        if (this.httpProxyPort != null) {
            optionMap.put("http-proxy-port", new CommandLineOption("http-proxy-port", new String[]{this.httpProxyPort}));
        }
        if (this.httpProxyUser != null) {
            optionMap.put("http-proxy-user", new CommandLineOption("http-proxy-user", new String[]{this.httpProxyUser}));
        }
        if (this.httpProxyPassword != null) {
            optionMap.put("http-proxy-password", new CommandLineOption("http-proxy-password", new String[]{this.httpProxyPassword}));
        }
        return optionMap;
    }

    private String getNamespaceToPackagesMap() throws MojoFailureException {
        StringBuffer sb = new StringBuffer();
        if (this.namespaceToPackages != null) {
            sb.append(this.namespaceToPackages);
        }
        if (this.namespaceURIs != null) {
            for (int i = 0; i < this.namespaceURIs.length; ++i) {
                NamespaceURIMapping mapping = this.namespaceURIs[i];
                String uri = mapping.getUri();
                if (uri == null) {
                    throw new MojoFailureException("A namespace to package mapping requires an uri child element.");
                }
                String uriPackageName = mapping.getPackageName();
                if (uriPackageName == null) {
                    throw new MojoFailureException("A namespace to package mapping requires a packageName child element.");
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(uri);
                sb.append('=');
                sb.append(uriPackageName);
            }
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.fixCompileSourceRoots();
        this.showDependencies();
        Map<String, CommandLineOption> commandLineOptions = this.fillOptionMap();
        CommandLineOptionParser parser = new CommandLineOptionParser(commandLineOptions);
        try {
            new CodeGenerationEngine(parser).generate();
        }
        catch (CodeGenerationException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void showDependencies() {
        Log log = this.getLog();
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((CharSequence)"The projects dependency artifacts are: ");
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            log.debug((CharSequence)("    " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getScope() + ":" + artifact.getType()));
        }
        log.debug((CharSequence)"The projects transitive artifacts are: ");
        for (Artifact artifact : this.project.getArtifacts()) {
            log.debug((CharSequence)("    " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getScope() + ":" + artifact.getType()));
        }
    }

    private void fixCompileSourceRoots() {
        File srcDir = new File(this.outputDirectory, this.targetSourceFolderLocation);
        this.project.addCompileSourceRoot(srcDir.getPath());
    }
}

