/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.webapp;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.webapp.ActionResult;
import org.apache.axis2.webapp.Status;
import org.apache.axis2.webapp.StatusCache;

final class Redirect
extends ActionResult {
    private final String action;
    private final Map<String, String> parameters = new LinkedHashMap();
    private Status status;

    Redirect(String action) {
        this.action = action;
    }

    Redirect withParameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    Redirect withStatus(boolean success, String message) {
        this.status = new Status(success, message);
        return this;
    }

    void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringBuilder url = new StringBuilder(response.encodeRedirectURL(this.action));
        if (this.status != null) {
            HttpSession session = request.getSession();
            StatusCache statusCache = (StatusCache)session.getAttribute(StatusCache.class.getName());
            if (statusCache == null) {
                statusCache = new StatusCache();
            }
            this.parameters.put("status", statusCache.add(this.status));
            session.setAttribute(StatusCache.class.getName(), (Object)statusCache);
        }
        boolean first = true;
        for (Map.Entry parameter : this.parameters.entrySet()) {
            if (first) {
                url.append('?');
                first = false;
            } else {
                url.append('&');
            }
            url.append((String)parameter.getKey());
            url.append('=');
            url.append(URLEncoder.encode((String)parameter.getValue(), "UTF-8"));
        }
        response.sendRedirect(url.toString());
    }
}

