/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.MethodRetriever;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyMethodRetrieverImpl
extends MethodRetriever {
    private static final Log log = LogFactory.getLog(LegacyMethodRetrieverImpl.class);
    private EndpointInterfaceDescriptionImpl eid = null;
    private DescriptionBuilderComposite dbc = null;

    public LegacyMethodRetrieverImpl(DescriptionBuilderComposite dbc, EndpointInterfaceDescriptionImpl eid) {
        this.dbc = dbc;
        this.eid = eid;
    }

    @Override
    public Iterator<MethodDescriptionComposite> retrieveMethods() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"retrieveReleventMethods: Enter");
        }
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList();
        if (this.dbc.isInterface()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing overridden methods for interface: " + this.dbc.getClassName() + " with super interface: " + this.dbc.getSuperClassName()));
            }
            retrieveList = this.retrieveSEIMethodsChain(this.dbc, this.eid);
            retrieveList = this.removeOverriddenMethods(retrieveList, this.dbc, this.eid);
        } else {
            retrieveList = this.retrieveImplicitSEIMethods(this.dbc);
            DescriptionBuilderComposite tempDBC = this.dbc;
            while (!DescriptionUtils.isEmpty(tempDBC.getSuperClassName()) && !DescriptionUtils.javifyClassName(tempDBC.getSuperClassName()).equals("java.lang.Object")) {
                DescriptionBuilderComposite superDBC = this.eid.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap().get(tempDBC.getSuperClassName());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("superclass name for this DBC is:" + tempDBC.getSuperClassName()));
                }
                if (superDBC == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("seiNotFoundErr"));
                }
                if (superDBC.getWebServiceAnnot() != null) {
                    retrieveList.addAll(this.retrieveImplicitSEIMethods(superDBC));
                }
                tempDBC = superDBC;
            }
            retrieveList = this.removeOverriddenMethods(retrieveList, this.dbc, this.eid);
        }
        return retrieveList.iterator();
    }

    private ArrayList<MethodDescriptionComposite> retrieveImplicitSEIMethods(DescriptionBuilderComposite dbc) {
        String restrictStaticWebmethod = "jaxws.runtime.restrictStaticWebmethod";
        ArrayList<Object> retrieveList = new ArrayList();
        retrieveList = DescriptionUtils.getMethodsWithFalseExclusions(dbc);
        if (retrieveList == null || retrieveList.size() == 0) {
            Iterator<MethodDescriptionComposite> iter = null;
            List<MethodDescriptionComposite> mdcList = dbc.getMethodDescriptionsList();
            AxisConfiguration ac = this.eid.getEndpointDescription().getServiceDescription().getAxisConfigContext().getAxisConfiguration();
            Parameter p = ac.getParameter("jaxws.runtime.restrictStaticWebmethod");
            Boolean isRestrictStaticOperation = Boolean.FALSE;
            if (p != null) {
                isRestrictStaticOperation = DescriptionUtils.getBooleanValue((String)p.getValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("System property jaxws.runtime.restrictStaticWebmethod is set to :" + isRestrictStaticOperation));
                }
            }
            if (mdcList != null) {
                for (MethodDescriptionComposite mdc : dbc.getMethodDescriptionsList()) {
                    if (isRestrictStaticOperation.booleanValue()) {
                        if (mdc.isStatic() || DescriptionUtils.isExcludeTrue(mdc)) continue;
                        mdc.setDeclaringClass(dbc.getClassName());
                        retrieveList.add(mdc);
                        continue;
                    }
                    if (DescriptionUtils.isExcludeTrue(mdc)) continue;
                    mdc.setDeclaringClass(dbc.getClassName());
                    retrieveList.add(mdc);
                }
            }
        }
        return retrieveList;
    }
}

