/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl;

import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

public class WSDLUtil {
    public static boolean isInputPresentForMEP(String mep) {
        return "http://www.w3.org/ns/wsdl/in-opt-out".equals(mep) || "http://www.w3.org/ns/wsdl/in-only".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(mep) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(mep);
    }

    public static boolean isOutputPresentForMEP(String MEP) {
        return "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-in".equals(MEP) || "http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP);
    }

    public static QName getPartQName(String opName, String suffix, String partName) {
        return new QName(opName + suffix, partName);
    }

    public static String getConstantFromHTTPLocation(String httpLocation, String httpMethod) {
        int index;
        if (httpLocation.charAt(0) != '?') {
            httpLocation = "/" + httpLocation;
        }
        if ((index = httpLocation.indexOf("{")) > -1) {
            httpLocation = httpLocation.substring(0, index);
        }
        return httpMethod + httpLocation;
    }

    public static String getEndpointName(String serviceName, String protocol) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(serviceName);
        buffer.append(protocol.substring(0, 1).toUpperCase());
        buffer.append(protocol.substring(1, protocol.length()).toLowerCase());
        buffer.append("Endpoint");
        return buffer.toString();
    }

    public static void registerDefaultExtensionAttributeTypes(ExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new IllegalArgumentException("Extension registry must not be null");
        }
        QName finalWSANS = new QName("http://www.w3.org/2005/08/addressing", "Action");
        extensionRegistry.registerExtensionAttributeType(Input.class, finalWSANS, 0);
        extensionRegistry.registerExtensionAttributeType(Output.class, finalWSANS, 0);
        extensionRegistry.registerExtensionAttributeType(Fault.class, finalWSANS, 0);
        QName finalWSAWNS = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
        extensionRegistry.registerExtensionAttributeType(Input.class, finalWSAWNS, 0);
        extensionRegistry.registerExtensionAttributeType(Output.class, finalWSAWNS, 0);
        extensionRegistry.registerExtensionAttributeType(Fault.class, finalWSAWNS, 0);
        QName finalWSAMNS = new QName("http://www.w3.org/2007/05/addressing/metadata", "Action");
        extensionRegistry.registerExtensionAttributeType(Input.class, finalWSAMNS, 0);
        extensionRegistry.registerExtensionAttributeType(Output.class, finalWSAMNS, 0);
        extensionRegistry.registerExtensionAttributeType(Fault.class, finalWSAMNS, 0);
        QName submissionWSAWNS = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action");
        extensionRegistry.registerExtensionAttributeType(Input.class, submissionWSAWNS, 0);
        extensionRegistry.registerExtensionAttributeType(Output.class, submissionWSAWNS, 0);
        extensionRegistry.registerExtensionAttributeType(Fault.class, submissionWSAWNS, 0);
    }

    public static WSDLReader newWSDLReaderWithPopulatedExtensionRegistry() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader reader = wsdlFactory.newWSDLReader();
        ExtensionRegistry extensionRegistry = reader.getExtensionRegistry();
        if (extensionRegistry == null) {
            extensionRegistry = wsdlFactory.newPopulatedExtensionRegistry();
        }
        WSDLUtil.registerDefaultExtensionAttributeTypes(extensionRegistry);
        reader.setExtensionRegistry(extensionRegistry);
        return reader;
    }
}

