/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.mail.EmailReceiver;
import org.apache.axis2.transport.mail.MailWorkerManager;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleMailListener
implements Runnable,
TransportListener {
    private static final Log log = LogFactory.getLog((Class)SimpleMailListener.class);
    private ConfigurationContext configurationContext = null;
    private boolean running = true;
    private String user = "";
    private String replyTo = "";
    private Properties pop3Properties = new Properties();
    private EmailReceiver receiver = null;
    private int listenerWaitInterval = 180000;
    private ExecutorService workerPool;
    private static final int WORKERS_MAX_THREADS = 5;
    private static final long WORKER_KEEP_ALIVE = 60L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private LinkedBlockingQueue messageQueue;

    public void init(ConfigurationContext configurationContext, TransportInDescription transportIn) throws AxisFault {
        this.configurationContext = configurationContext;
        ArrayList mailParameters = transportIn.getParameters();
        this.replyTo = Utils.getParameterValue(transportIn.getParameter("transport.mail.replyToAddress"));
        Parameter listenerWaitIntervalParam = transportIn.getParameter("transport.listener.interval");
        if (listenerWaitIntervalParam != null) {
            this.listenerWaitInterval = Integer.parseInt(Utils.getParameterValue(listenerWaitIntervalParam));
        }
        String password = "";
        String host = "";
        String protocol = "";
        String port = "";
        Iterator iterator = mailParameters.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            String paramKey = param.getName();
            String paramValue = Utils.getParameterValue(param);
            if (paramKey == null || paramValue == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Parameter name nor value should be null"));
            }
            this.pop3Properties.setProperty(paramKey, paramValue);
            if (paramKey.equals("mail.pop3.user")) {
                this.user = paramValue;
            }
            if (paramKey.equals("transport.mail.pop3.password")) {
                password = paramValue;
            }
            if (paramKey.equals("mail.pop3.host")) {
                host = paramValue;
            }
            if (paramKey.equals("mail.store.protocol")) {
                protocol = paramValue;
            }
            if (!paramKey.equals("mail.pop3.port")) continue;
            port = paramValue;
        }
        if (password.length() == 0 || this.user.length() == 0 || host.length() == 0 || protocol.length() == 0) {
            throw new AxisFault("One or more of Password, User, Host and Protocol are null or empty");
        }
        URLName urlName = port.length() == 0 ? new URLName(protocol, host, -1, "", this.user, password) : new URLName(protocol, host, Integer.parseInt(port), "", this.user, password);
        this.receiver = new EmailReceiver();
        this.receiver.setPop3Properties(this.pop3Properties);
        this.receiver.setUrlName(urlName);
    }

    public static void main(String[] args) throws AxisFault {
        if (args.length < 2) {
            log.info((Object)"java SimpleMailListener <repository>");
            SimpleMailListener.printUsage();
        } else {
            String path = args[0];
            String axis2xml = args[1];
            File repo = new File(path);
            if (!repo.exists()) {
                SimpleMailListener.printUsage();
                throw new AxisFault("repository not found");
            }
            ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(path, axis2xml);
            SimpleMailListener sas = new SimpleMailListener();
            TransportInDescription transportIn = configurationContext.getAxisConfiguration().getTransportIn(new QName("mail"));
            if (transportIn != null) {
                sas.init(configurationContext, transportIn);
                log.info((Object)("Starting the SimpleMailListener with repository " + new File(args[0]).getAbsolutePath()));
                sas.start();
            } else {
                log.info((Object)"Startup failed, mail transport not configured, Configure the mail trnasport in the axis2.xml file");
            }
        }
    }

    private static void printUsage() {
        System.out.println("Please provide the repository location and axis2.xml location ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.running) {
            log.info((Object)("Mail listner strated to listen to the address " + this.user));
        }
        while (this.running) {
            try {
                this.receiver.connect();
                Message[] msgs = this.receiver.receiveMessages();
                if (msgs != null && msgs.length > 0) {
                    log.info((Object)(msgs.length + " Message Found"));
                    for (int i = 0; i < msgs.length; ++i) {
                        MimeMessage msg = (MimeMessage)msgs[i];
                        MessageContext mc = this.createMessageContextToMailWorker(msg);
                        if (mc != null) {
                            this.messageQueue.add((Object)mc);
                        }
                        msg.setFlag(Flags.Flag.DELETED, true);
                    }
                }
                this.receiver.disconnect();
            }
            catch (Exception e) {
                log.error((Object)("Error in SimpleMailListener" + e));
            }
            finally {
                try {
                    Thread.sleep(this.listenerWaitInterval);
                }
                catch (InterruptedException e) {
                    log.warn((Object)("Error Encountered " + e));
                }
            }
        }
    }

    private MessageContext createMessageContextToMailWorker(MimeMessage msg) throws Exception {
        MessageContext msgContext = null;
        TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn(new QName("mail"));
        TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut(new QName("mail"));
        if (transportIn != null && transportOut != null) {
            String soapNamespaceURI;
            msgContext = new MessageContext();
            msgContext.setConfigurationContext(this.configurationContext);
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
            msgContext.setProperty("mail.contenttype", msg.getContentType());
            if (TransportUtils.getCharSetEncoding(msg.getContentType()) != null) {
                msgContext.setProperty("CHARACTER_SET_ENCODING", TransportUtils.getCharSetEncoding(msg.getContentType()));
            } else {
                msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
            }
            msgContext.setIncomingTransportName("mail");
            String soapAction = this.getMailHeader(msg, "mail.soapaction");
            msgContext.setSoapAction(soapAction);
            if (msg.getSubject() != null) {
                msgContext.setTo(new EndpointReference(msg.getSubject()));
            }
            String message = msg.getContent().toString();
            ByteArrayInputStream bais = new ByteArrayInputStream(message.getBytes());
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)bais);
            if (msg.getContentType().indexOf("application/soap+xml") > -1) {
                soapNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
                int index = msg.getContentType().indexOf("action");
                if (index > -1) {
                    String transientString = msg.getContentType().substring(index, msg.getContentType().length());
                    int equal = transientString.indexOf("=");
                    int firstSemiColon = transientString.indexOf(";");
                    soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
                    if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                        soapAction = soapAction.substring(1, soapAction.length() - 1);
                    }
                    msgContext.setSoapAction(soapAction);
                }
            } else if (msg.getContentType().indexOf("text/xml") > -1) {
                soapNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
            } else {
                log.warn((Object)"MailWorker found a message other than text/xml or application/soap+xml");
                return null;
            }
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, soapNamespaceURI);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgContext.setEnvelope(envelope);
        }
        return msgContext;
    }

    private String getMailHeader(MimeMessage msg, String headerName) throws AxisFault {
        try {
            String[] values = msg.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    public void start() throws AxisFault {
        this.workerPool = new ThreadPoolExecutor(1, 5, 60L, TIME_UNIT, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new DefaultThreadFactory(new ThreadGroup("Mail Worker thread group"), "MailWorker"));
        this.messageQueue = new LinkedBlockingQueue();
        this.configurationContext.getThreadPool().execute(this);
        MailWorkerManager mailWorkerManager = new MailWorkerManager(this.configurationContext, this.messageQueue, this.workerPool, 5);
        mailWorkerManager.start();
    }

    public void stop() {
        this.running = true;
        if (!this.workerPool.isShutdown()) {
            this.workerPool.shutdown();
        }
        log.info((Object)"Stopping the mail listner");
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{new EndpointReference("mail:" + this.replyTo + this.configurationContext.getServiceContextPath() + "/" + serviceName)};
    }
}

