/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.server.DefaultHttpConnectionFactory;
import org.apache.axis2.transport.http.server.HttpServiceProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.axis2.transport.http.server.OutputBuffer;
import org.apache.axis2.transport.http.server.RequestSessionCookie;
import org.apache.axis2.transport.http.server.ResponseSessionCookie;
import org.apache.axis2.transport.http.server.SessionManager;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class DefaultHttpServiceProcessor
extends HttpServiceProcessor {
    private static final Log LOG = LogFactory.getLog((Class)DefaultHttpServiceProcessor.class);
    private static final Log HEADERLOG = LogFactory.getLog((String)"org.apache.axis2.transport.http.server.wire");
    private final ConfigurationContext configurationContext;
    private final SessionManager sessionManager;
    private final Worker worker;
    private final IOProcessorCallback callback;
    private HttpServerConnection conn;
    private HttpContext httpcontext = null;

    public DefaultHttpServiceProcessor(HttpServerConnection conn, ConfigurationContext configurationContext, SessionManager sessionManager, Worker worker, IOProcessorCallback callback) {
        super(conn);
        this.conn = conn;
        if (worker == null) {
            throw new IllegalArgumentException("Worker may not be null");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        if (sessionManager == null) {
            throw new IllegalArgumentException("Session manager may not be null");
        }
        this.configurationContext = configurationContext;
        this.sessionManager = sessionManager;
        this.worker = worker;
        this.callback = callback;
        this.addInterceptor(new RequestSessionCookie());
        this.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        this.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        this.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.addInterceptor(new ResponseSessionCookie());
    }

    protected void postprocessResponse(HttpResponse response, HttpContext context) throws IOException, HttpException {
        super.postprocessResponse(response, context);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug((Object)("<< " + response.getStatusLine().toString()));
            Header[] headers = response.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERLOG.debug((Object)("<< " + headers[i].toString()));
            }
        }
    }

    protected void preprocessRequest(HttpRequest request, HttpContext context) throws IOException, HttpException {
        this.httpcontext = context;
        super.preprocessRequest(request, context);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug((Object)(">> " + request.getRequestLine().toString()));
            Header[] headers = request.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERLOG.debug((Object)(">> " + headers[i].toString()));
            }
        }
    }

    protected void doService(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block14: {
            HttpVersion ver;
            RequestLine reqline = request.getRequestLine();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request method: " + reqline.getMethod()));
                LOG.debug((Object)("Target URI: " + reqline.getUri()));
            }
            if (!(ver = reqline.getHttpVersion()).lessEquals(HttpVersion.HTTP_1_1)) {
                throw new UnsupportedHttpVersionException("Unsupported HTTP version: " + ver);
            }
            MessageContext msgContext = new MessageContext();
            msgContext.setIncomingTransportName("http");
            if (this.conn instanceof DefaultHttpConnectionFactory.Axis2HttpServerConnection) {
                DefaultHttpConnectionFactory.Axis2HttpServerConnection axis2Con = (DefaultHttpConnectionFactory.Axis2HttpServerConnection)this.conn;
                msgContext.setProperty("REMOTE_ADDR", axis2Con.getRemoteIPAddress());
                LOG.debug((Object)("Remote address of the connection : " + axis2Con.getRemoteIPAddress()));
            }
            try {
                TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut(new QName("http"));
                TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn(new QName("http"));
                msgContext.setConfigurationContext(this.configurationContext);
                String sessionKey = (String)this.httpcontext.getAttribute("Cookie");
                if (this.configurationContext.getAxisConfiguration().isManageTransportSession()) {
                    SessionContext sessionContext = this.sessionManager.getSessionContext(sessionKey);
                    msgContext.setSessionContext(sessionContext);
                }
                msgContext.setTransportIn(transportIn);
                msgContext.setTransportOut(transportOut);
                msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
                msgContext.setServerSide(true);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                Iterator it = request.headerIterator();
                while (it.hasNext()) {
                    Header header = (Header)it.next();
                    headerMap.put(header.getName(), header.getValue());
                }
                msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
                this.httpcontext.setAttribute("axis.message.context", (Object)msgContext);
                this.worker.service(request, response, msgContext);
            }
            catch (SocketException ex) {
                throw ex;
            }
            catch (HttpException ex) {
                throw ex;
            }
            catch (Throwable e) {
                try {
                    AxisEngine engine = new AxisEngine(this.configurationContext);
                    OutputBuffer outbuffer = new OutputBuffer();
                    msgContext.setProperty("TRANSPORT_OUT", outbuffer.getOutputStream());
                    msgContext.setProperty("OutTransportInfo", outbuffer);
                    MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
                    if (AddressingHelper.isFaultRedirected(msgContext)) {
                        response.setStatusLine(new StatusLine(ver, 202, "Accepted"));
                    } else {
                        response.setStatusLine(new StatusLine(ver, 500, "Internal server error"));
                    }
                    engine.sendFault(faultContext);
                    response.setEntity((HttpEntity)outbuffer);
                }
                catch (Exception ex) {
                    if (AddressingHelper.isFaultRedirected(msgContext)) {
                        response.setStatusLine(new StatusLine(ver, 202, "Accepted"));
                        break block14;
                    }
                    response.setStatusLine(new StatusLine(ver, 500, "Internal server error"));
                    String msg = ex.getMessage();
                    StringEntity entity = msg != null && msg.trim().length() != 0 ? new StringEntity(msg) : new StringEntity("Exception message unknown");
                    entity.setContentType("text/plain");
                    response.setEntity((HttpEntity)entity);
                }
            }
        }
    }

    protected void logIOException(IOException ex) {
        if (ex instanceof SocketTimeoutException) {
            LOG.debug((Object)ex.getMessage());
        } else if (ex instanceof SocketException) {
            LOG.debug((Object)ex.getMessage());
        } else {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void logMessage(String s) {
        LOG.debug((Object)s);
    }

    protected void logProtocolException(HttpException ex) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("HTTP protocol error: " + ex.getMessage()));
        }
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.debug((Object)"New connection thread");
        try {
            while (!Thread.interrupted() && !this.isDestroyed() && this.isActive()) {
                this.handleRequest();
            }
        }
        finally {
            this.destroy();
            if (this.callback != null) {
                this.callback.completed(this);
            }
        }
    }
}

