/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSDL11ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    protected static final Log log = LogFactory.getLog((Class)WSDL11ToAxisServiceBuilder.class);
    protected String portName;
    private static final String BINDING = "Binding";
    private static final String SERVICE = "Service";
    private static final String PORT = "Port";
    private static final String PORT_TYPE = "PortType";
    private static final String PORT_TYPE_OPERATION = "PortType.Operation";
    private static final String PORT_TYPE_OPERATION_INPUT = "PortType.Operation.Input";
    private static final String PORT_TYPE_OPERATION_OUTPUT = "PortType.Operation.Output";
    private static final String PORT_TYPE_OPERATION_FAULT = "PortType.Operation.Fault";
    private static final String BINDING_OPERATION = "Binding.Operation";
    private static final String BINDING_OPERATION_INPUT = "Binding.Operation.Input";
    private static final String BINDING_OPERATION_OUTPUT = "Binding.Operation.Output";
    protected Definition wsdl4jDefinition = null;
    private WSDLLocator customWSLD4JResolver;
    public static final String RPC_STYLE = "rpc";
    public static final String DOCUMENT_STYLE = "document";
    private List wrappableOperations = new ArrayList();
    public static final String WRAPPED_OUTPUTNAME_SUFFIX = "Response";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String NAMESPACE_DECLARATION_PREFIX = "xmlns:";
    private static int prefixCounter = 0;
    public static final String NAMESPACE_URI = "namespace";
    public static final String TRAGET_NAMESPACE = "targetNamespace";
    private boolean setupComplete = false;
    private Map schemaMap = null;
    private static final String JAVAX_WSDL_VERBOSE_MODE_KEY = "javax.wsdl.verbose";
    private static final String JAVAX_WSDL_IMPORT_DOCUMENTS_MODE_KEY = "javax.wsdl.importDocuments";

    public WSDL11ToAxisServiceBuilder(InputStream in, QName serviceName, String portName) {
        super(in, serviceName);
        this.portName = portName;
    }

    public WSDL11ToAxisServiceBuilder(Definition def, QName serviceName, String portName) {
        super(null, serviceName);
        this.wsdl4jDefinition = def;
        this.portName = portName;
    }

    public WSDL11ToAxisServiceBuilder(InputStream in, AxisService service) {
        super(in, service);
    }

    public WSDL11ToAxisServiceBuilder(InputStream in) {
        this(in, null, null);
    }

    public void setCustomWSLD4JResolver(WSDLLocator customWSLD4JResolver) {
        this.customWSLD4JResolver = customWSLD4JResolver;
    }

    public AxisService populateService() throws AxisFault {
        try {
            Element documentationElement;
            this.setup();
            Parameter wsdlDefinitionParameter = new Parameter();
            wsdlDefinitionParameter.setName("wsdl4jDefinition");
            wsdlDefinitionParameter.setValue(this.wsdl4jDefinition);
            this.axisService.addParameter(wsdlDefinitionParameter);
            if (this.wsdl4jDefinition == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.wsdl4jDefinition.getTargetNamespace());
            this.axisService.setNameSpacesMap(new NamespaceMap(this.wsdl4jDefinition.getNamespaces()));
            Binding binding = this.findBinding(this.wsdl4jDefinition);
            if (binding.getPortType() == null) {
                throw new AxisFault("Unable to find wsdl:binding named " + binding.getQName());
            }
            Element[] schemaElements = this.generateWrapperSchema(this.schemaMap, binding);
            Types wsdl4jTypes = this.wsdl4jDefinition.getTypes();
            if (null != wsdl4jTypes) {
                this.copyExtensibleElements(wsdl4jTypes.getExtensibilityElements(), this.wsdl4jDefinition, this.axisService, "Types");
            }
            if (schemaElements != null && schemaElements.length > 0) {
                for (int i = 0; i < schemaElements.length; ++i) {
                    Element schemaElement = schemaElements[i];
                    if (schemaElement == null) continue;
                    this.axisService.addSchema(this.getXMLSchema(schemaElement, null));
                }
            }
            if ((documentationElement = this.wsdl4jDefinition.getDocumentationElement()) != null && documentationElement.getFirstChild() != null) {
                Node firstChild = documentationElement.getFirstChild();
                String serviceDes = firstChild.getNodeType() == 3 ? firstChild.getNodeValue() : DOM2Writer.nodeToString((Node)firstChild);
                this.axisService.setServiceDescription(serviceDes);
            }
            this.processBinding(binding, this.wsdl4jDefinition);
            return this.axisService;
        }
        catch (WSDLException e) {
            log.error((Object)e);
            throw new AxisFault(e);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new AxisFault(e);
        }
    }

    protected void setup() throws WSDLException {
        if (this.setupComplete) {
            return;
        }
        if (this.wsdl4jDefinition == null) {
            this.wsdl4jDefinition = this.readInTheWSDLFile(this.in);
        }
        if (this.wsdl4jDefinition == null) {
            return;
        }
        this.processImports(this.wsdl4jDefinition, new ArrayList());
        this.processPoliciesInDefintion(this.wsdl4jDefinition);
        this.schemaMap = this.populateSchemaMap(this.wsdl4jDefinition.getTypes());
        this.setupComplete = true;
    }

    private Map populateSchemaMap(Types wsdl4jTypes) {
        HashMap<String, Element> schemaMap = new HashMap<String, Element>();
        if (wsdl4jTypes != null) {
            List typesExtensibilityElements = wsdl4jTypes.getExtensibilityElements();
            for (int i = 0; i < typesExtensibilityElements.size(); ++i) {
                Object o = typesExtensibilityElements.get(i);
                if (!(o instanceof Schema)) continue;
                Schema s = (Schema)o;
                String targetNamespace = s.getElement().getAttribute(TRAGET_NAMESPACE);
                schemaMap.put(targetNamespace, s.getElement());
            }
        }
        return schemaMap;
    }

    private Binding findBinding(Definition dif) throws AxisFault {
        Map services = dif.getServices();
        Service service = null;
        Binding binding = null;
        Port port = null;
        if (this.serviceName != null) {
            service = (Service)services.get(this.serviceName);
            if (service == null) {
                throw new AxisFault("Service " + this.serviceName + " was not found in the WSDL");
            }
        } else if (services.size() > 0) {
            service = (Service)services.values().toArray()[0];
        }
        if (service != null) {
            this.copyExtensibleElements(service.getExtensibilityElements(), dif, this.axisService, SERVICE);
            if (this.portName != null) {
                port = service.getPort(this.portName);
                if (port == null) {
                    throw new AxisFault("No port found for the given name :" + this.portName);
                }
            } else {
                Map ports = service.getPorts();
                if (ports != null && ports.size() > 0 && (port = this.findSOAPPort(ports)) == null) {
                    log.info((Object)"A SOAP port was not found - picking a random port!");
                    port = (Port)ports.values().toArray()[0];
                }
            }
            this.axisService.setName(service.getQName().getLocalPart());
            if (port != null) {
                this.copyExtensibleElements(port.getExtensibilityElements(), dif, this.axisService, PORT);
                binding = dif.getBinding(port.getBinding().getQName());
                if (binding == null) {
                    binding = port.getBinding();
                }
            }
        } else {
            log.info((Object)"A service element was not found - picking a random binding!");
            Collection bindings = dif.getBindings().values();
            if (bindings == null || bindings.isEmpty()) {
                throw new AxisFault("No bindings found in wsdl");
            }
            binding = (Binding)bindings.iterator().next();
            this.axisService.setName(binding.getQName().getLocalPart() + SERVICE);
        }
        return binding;
    }

    private Port findSOAPPort(Map ports) {
        Iterator portsIterator = ports.values().iterator();
        while (portsIterator.hasNext()) {
            Port port = (Port)portsIterator.next();
            List extensibilityElements = port.getExtensibilityElements();
            for (int i = 0; i < extensibilityElements.size(); ++i) {
                Object extElement = extensibilityElements.get(i);
                if (extElement instanceof SOAPAddress) {
                    return port;
                }
                if (!(extElement instanceof SOAP12Address)) continue;
                return port;
            }
        }
        return null;
    }

    private void processBinding(Binding binding, Definition dif) throws Exception {
        if (binding != null) {
            this.copyExtensibleElements(binding.getExtensibilityElements(), dif, this.axisService, BINDING);
            PortType portType = dif.getPortType(binding.getPortType().getQName());
            this.processPortType(portType, dif);
            this.axisService.setBindingName(binding.getQName().getLocalPart());
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation wsdl4jBindingOperation = (BindingOperation)list.get(i);
                AxisOperation operation = this.axisService.getOperation(new QName(wsdl4jBindingOperation.getName()));
                String style = this.getSOAPStyle(wsdl4jBindingOperation);
                if (style != null) {
                    operation.setStyle(style);
                } else if (this.style != null) {
                    operation.setStyle(this.style);
                }
                this.copyExtensibleElements(wsdl4jBindingOperation.getExtensibilityElements(), dif, operation, BINDING_OPERATION);
                BindingInput bindingInput = wsdl4jBindingOperation.getBindingInput();
                BindingOutput bindingOutput = wsdl4jBindingOperation.getBindingOutput();
                Map bindingFaultsMap = wsdl4jBindingOperation.getBindingFaults();
                Operation wsdl4jOperation = this.findOperation(portType, wsdl4jBindingOperation);
                String MEP = operation.getMessageExchangePattern();
                if (bindingInput != null && WSDLUtil.isInputPresentForMEP(MEP)) {
                    AxisMessage inAxisMessage = operation.getMessage("In");
                    this.AddQNameReference(inAxisMessage, wsdl4jOperation, bindingInput, this.wrappableOperations.contains(wsdl4jBindingOperation.getOperation()));
                    this.copyExtensibleElements(bindingInput.getExtensibilityElements(), dif, inAxisMessage, BINDING_OPERATION_INPUT);
                }
                if (bindingOutput != null && WSDLUtil.isOutputPresentForMEP(MEP)) {
                    AxisMessage outAxisMessage = operation.getMessage("Out");
                    this.AddQNameReference(outAxisMessage, wsdl4jOperation, bindingOutput, this.wrappableOperations.contains(wsdl4jBindingOperation.getOperation()));
                    this.copyExtensibleElements(bindingOutput.getExtensibilityElements(), dif, outAxisMessage, BINDING_OPERATION_OUTPUT);
                }
                Iterator faultKeys = bindingFaultsMap.keySet().iterator();
                while (faultKeys.hasNext()) {
                    Object faultMapKey = faultKeys.next();
                    BindingFault bindingFault = (BindingFault)bindingFaultsMap.get(faultMapKey);
                    Fault wsdl4jFault = wsdl4jOperation.getFault(bindingFault.getName());
                    if (wsdl4jFault == null || wsdl4jFault.getMessage().getParts().size() == 0) {
                        throw new AxisFault("fault \"" + bindingFault.getName() + "\" not found in the Operation " + wsdl4jOperation.getName());
                    }
                    AxisMessage faultMessage = this.findFaultMessage(wsdl4jFault.getMessage().getQName().getLocalPart(), operation.getFaultMessages());
                    this.AddQNameReference(faultMessage, wsdl4jFault.getMessage());
                }
                Iterator iterator = operation.getFaultMessages().iterator();
                while (iterator.hasNext()) {
                    AxisMessage faultMessage = (AxisMessage)iterator.next();
                    if (faultMessage.getElementQName() != null) continue;
                    log.warn((Object)("Unable to find a wsdl:binding/wsdl:operation/wsdl:fault for fault named " + faultMessage.getName() + " defined in wsdl:portType/wsdl:operation/@name=" + operation.getName().getLocalPart()));
                }
            }
        }
    }

    private Operation findOperation(PortType portType, BindingOperation wsdl4jBindingOperation) {
        Operation op2;
        Operation op = wsdl4jBindingOperation.getOperation();
        String input = null;
        if (op != null && op.getInput() != null && ":none".equals(input = op.getInput().getName())) {
            input = null;
        }
        String output = null;
        if (op != null && op.getOutput() != null && ":none".equals(output = op.getOutput().getName())) {
            output = null;
        }
        return (op2 = portType.getOperation(op.getName(), input, output)) == null ? op : op2;
    }

    private AxisMessage findFaultMessage(String name, ArrayList faultMessages) {
        for (int i = 0; i < faultMessages.size(); ++i) {
            AxisMessage tempMessage = (AxisMessage)faultMessages.get(i);
            if (!name.equals(tempMessage.getName())) continue;
            return tempMessage;
        }
        return null;
    }

    private void AddQNameReference(AxisMessage inMessage, Operation wsdl4jOperation, BindingInput bindingInput, boolean isWrapped) {
        List extensibilityElements = bindingInput.getExtensibilityElements();
        Message wsdl4jMessage = wsdl4jOperation.getInput().getMessage();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Part wsdl4jPart;
            Map wsdl4jPartsMap;
            ExtensibilityElement extElement = (ExtensibilityElement)extensibilityElements.get(i);
            if (extElement instanceof SOAPBody) {
                Part wsdl4jPart2;
                Map wsdl4jPartsMap2;
                SOAPBody soapBody = (SOAPBody)extElement;
                List bindingPartsList = soapBody.getParts();
                if (bindingPartsList != null && !bindingPartsList.isEmpty()) {
                    this.processPartsList(bindingPartsList, wsdl4jMessage, inMessage);
                    break;
                }
                if (isWrapped) {
                    inMessage.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(wsdl4jOperation.getName()));
                    break;
                }
                if (wsdl4jMessage == null || (wsdl4jPartsMap2 = wsdl4jMessage.getParts()).isEmpty() || (wsdl4jPart2 = (Part)wsdl4jPartsMap2.values().toArray()[0]).getElementName() == null) break;
                inMessage.setElementQName(wsdl4jPart2.getElementName());
                break;
            }
            if (!(extElement instanceof SOAP12Body)) continue;
            SOAP12Body soapBody = (SOAP12Body)extElement;
            List bindingPartsList = soapBody.getParts();
            if (bindingPartsList != null && !bindingPartsList.isEmpty()) {
                this.processPartsList(bindingPartsList, wsdl4jMessage, inMessage);
                break;
            }
            if (isWrapped) {
                inMessage.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(wsdl4jOperation.getName()));
                break;
            }
            if (wsdl4jMessage == null || (wsdl4jPartsMap = wsdl4jMessage.getParts()).isEmpty() || (wsdl4jPart = (Part)wsdl4jPartsMap.values().toArray()[0]).getElementName() == null) break;
            inMessage.setElementQName(wsdl4jPart.getElementName());
            break;
        }
    }

    private void processPartsList(List bindingPartsList, Message wsdl4jMessage, AxisMessage axisMessage) {
        if (bindingPartsList.size() <= 1) {
            Part wsdl4jMessagePart = wsdl4jMessage.getPart((String)bindingPartsList.get(0));
            if (wsdl4jMessagePart == null) {
                throw new WSDLProcessingException("Missing part named \"" + bindingPartsList.get(0) + "\"");
            }
            QName name = wsdl4jMessagePart.getElementName();
            if (name == null) {
                name = wsdl4jMessagePart.getTypeName();
            }
            if (name == null) {
                throw new WSDLProcessingException("Element reference / Type name  missing for " + bindingPartsList.get(0) + "!");
            }
            axisMessage.setElementQName(wsdl4jMessagePart.getElementName());
        }
    }

    private void AddQNameReference(AxisMessage outMessage, Operation wsdl4jOperation, BindingOutput bindingOutput, boolean isWrapped) {
        List extensibilityElements = bindingOutput.getExtensibilityElements();
        if (wsdl4jOperation.getOutput() == null) {
            return;
        }
        Message wsdl4jMessage = wsdl4jOperation.getOutput().getMessage();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Part wsdl4jPart;
            Map wsdl4jPartsMap;
            List bindingPartsList;
            SOAPBody soapBody;
            ExtensibilityElement extElement = (ExtensibilityElement)extensibilityElements.get(i);
            if (extElement instanceof SOAPBody) {
                soapBody = (SOAPBody)extElement;
                bindingPartsList = soapBody.getParts();
                if (bindingPartsList != null && !bindingPartsList.isEmpty()) {
                    this.processPartsList(bindingPartsList, wsdl4jMessage, outMessage);
                    continue;
                }
                if (isWrapped) {
                    outMessage.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(wsdl4jOperation.getName() + WRAPPED_OUTPUTNAME_SUFFIX));
                    continue;
                }
                if (wsdl4jMessage == null || (wsdl4jPartsMap = wsdl4jMessage.getParts()).isEmpty() || (wsdl4jPart = (Part)wsdl4jPartsMap.values().toArray()[0]).getElementName() == null) continue;
                outMessage.setElementQName(wsdl4jPart.getElementName());
                continue;
            }
            if (!(extElement instanceof SOAP12Body)) continue;
            soapBody = (SOAP12Body)extElement;
            bindingPartsList = soapBody.getParts();
            if (bindingPartsList != null && !bindingPartsList.isEmpty()) {
                this.processPartsList(bindingPartsList, wsdl4jMessage, outMessage);
                continue;
            }
            if (isWrapped) {
                outMessage.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(wsdl4jOperation.getName() + WRAPPED_OUTPUTNAME_SUFFIX));
                continue;
            }
            if (wsdl4jMessage == null || (wsdl4jPartsMap = wsdl4jMessage.getParts()).isEmpty() || (wsdl4jPart = (Part)wsdl4jPartsMap.values().toArray()[0]).getElementName() == null) continue;
            outMessage.setElementQName(wsdl4jPart.getElementName());
        }
    }

    private void AddQNameReference(AxisMessage faultMessage, Message wsdl4jMessage) throws AxisFault {
        Part wsdl4jMessagePart = (Part)wsdl4jMessage.getParts().values().toArray()[0];
        if (wsdl4jMessagePart == null) {
            throw new WSDLProcessingException();
        }
        QName name = wsdl4jMessagePart.getElementName();
        if (name == null) {
            String message = "Part '" + wsdl4jMessagePart.getName() + "' of fault message '" + wsdl4jMessage.getQName() + "' must be defined with 'element=QName' and not 'type=QName'";
            log.error((Object)message);
            throw new AxisFault(message);
        }
        faultMessage.setElementQName(name);
    }

    private String getSOAPStyle(BindingOperation bindingOp) {
        List extensibilityElements = bindingOp.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Object extElement = extensibilityElements.get(i);
            if (extElement instanceof SOAPOperation) {
                return ((SOAPOperation)extElement).getStyle();
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            return ((SOAP12Operation)extElement).getStyle();
        }
        return null;
    }

    private void processPortType(PortType wsdl4jPortType, Definition dif) throws Exception {
        this.copyExtensionAttributes(wsdl4jPortType.getExtensionAttributes(), this.axisService, PORT_TYPE);
        this.axisService.setPortTypeName(wsdl4jPortType.getQName().getLocalPart());
        Iterator wsdl4JOperationsIterator = wsdl4jPortType.getOperations().iterator();
        while (wsdl4JOperationsIterator.hasNext()) {
            Operation wsdl4jOperation = (Operation)wsdl4JOperationsIterator.next();
            this.axisService.addOperation(this.populateOperations(wsdl4jOperation, wsdl4jPortType, dif));
        }
    }

    private AxisOperation populateOperations(Operation wsdl4jOperation, PortType wsdl4jPortType, Definition dif) throws Exception {
        Message message;
        AxisMessage outMessage;
        Output wsdl4jOutputMessage;
        Message message2;
        AxisMessage inMessage;
        QName opName = new QName(wsdl4jOperation.getName());
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP = this.getMEP(wsdl4jOperation);
            axisOperation = AxisOperationFactory.getOperationDescription(MEP);
            axisOperation.setName(opName);
            PolicyInclude policyInclude = new PolicyInclude(axisOperation);
            axisOperation.setPolicyInclude(policyInclude);
        }
        this.copyExtensibleElements(wsdl4jOperation.getExtensibilityElements(), dif, axisOperation, PORT_TYPE_OPERATION);
        Input wsdl4jInputMessage = wsdl4jOperation.getInput();
        if (this.isServerSide) {
            String action;
            if (null != wsdl4jInputMessage) {
                inMessage = axisOperation.getMessage("In");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWsamappingList();
                action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList<String>();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("Out");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
        } else {
            if (null != wsdl4jInputMessage) {
                String action;
                inMessage = axisOperation.getMessage("Out");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("In");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWsamappingList();
                String action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList<String>();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                }
            }
        }
        Map faults = wsdl4jOperation.getFaults();
        Iterator faultKeyIterator = faults.keySet().iterator();
        while (faultKeyIterator.hasNext()) {
            String action;
            Fault fault = (Fault)faults.get(faultKeyIterator.next());
            AxisMessage axisFaultMessage = new AxisMessage();
            Message faultMessage = fault.getMessage();
            if (null != faultMessage) {
                axisFaultMessage.setName(faultMessage.getQName().getLocalPart());
                this.copyExtensibleElements(faultMessage.getExtensibilityElements(), dif, axisFaultMessage, PORT_TYPE_OPERATION_FAULT);
            }
            if ((action = axisOperation.getFaultAction(fault.getName())) == null) {
                action = WSDL11ActionHelper.getActionFromFaultElement(dif, wsdl4jPortType, wsdl4jOperation, fault);
            }
            if (action != null) {
                axisOperation.addFaultAction(fault.getName(), action);
            }
            axisOperation.setFaultMessages(axisFaultMessage);
        }
        return axisOperation;
    }

    private Element[] generateWrapperSchema(Map schemaMap, Binding wsdl4jBinding) {
        ArrayList<Element> schemaElementList = new ArrayList<Element>();
        String porttypeNamespaceURI = wsdl4jBinding.getPortType().getQName().getNamespaceURI();
        Element schemaElement = this.createSchemaForPorttype(porttypeNamespaceURI, this.findWrappableOperations(wsdl4jBinding), schemaMap);
        if (schemaElement != null) {
            schemaElementList.add(schemaElement);
        }
        return schemaElementList.toArray(new Element[schemaElementList.size()]);
    }

    private Element createSchemaForPorttype(String namespaceURI, List operationListToProcess, Map existingSchemaMap) {
        QName typeQName;
        if (operationListToProcess.isEmpty()) {
            return null;
        }
        HashMap<QName, Message> messagesMap = new HashMap<QName, Message>();
        HashMap<String, Message> inputOperationsMap = new HashMap<String, Message>();
        HashMap<String, Message> outputOperationsMap = new HashMap<String, Message>();
        HashMap faultyOperationsMap = new HashMap();
        HashMap<String, Element> namespaceImportsMap = new HashMap<String, Element>();
        HashMap<QName, Element> complexTypeElementsMap = new HashMap<QName, Element>();
        ArrayList<Element> elementElementsList = new ArrayList<Element>();
        HashMap<String, String> namespacePrefixMap = new HashMap<String, String>();
        for (int k = 0; k < operationListToProcess.size(); ++k) {
            Map faultMap;
            Output output;
            Message message;
            Operation op = (Operation)operationListToProcess.get(k);
            Input input = op.getInput();
            if (input != null) {
                message = input.getMessage();
                messagesMap.put(message.getQName(), message);
                inputOperationsMap.put(op.getName(), message);
            }
            if ((output = op.getOutput()) != null) {
                message = output.getMessage();
                messagesMap.put(message.getQName(), message);
                outputOperationsMap.put(op.getName(), message);
            }
            if ((faultMap = op.getFaults()) == null || faultMap.size() <= 0) continue;
            Iterator keys = faultMap.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Fault fault = (Fault)faultMap.get(key);
                if (fault == null) continue;
                message = fault.getMessage();
                messagesMap.put(message.getQName(), message);
                faultyOperationsMap.put(key, message);
            }
        }
        QName[] keys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
        ArrayList<QName> resolvedMessageQNames = new ArrayList<QName>();
        String xsdPrefix = this.findSchemaPrefix();
        Document document = this.getDOMDocumentBuilder().newDocument();
        for (int i = 0; i < keys.length; ++i) {
            Message wsdl4jMessage = (Message)messagesMap.get(keys[i]);
            if (resolvedMessageQNames.contains(wsdl4jMessage.getQName())) continue;
            Map parts = wsdl4jMessage.getParts();
            Element newComplexType = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "complexType");
            Element cmplxTypeSequence = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "sequence");
            Iterator iterator = parts.keySet().iterator();
            while (iterator.hasNext()) {
                String prefix;
                QName schemaTypeName;
                Part part = (Part)parts.get(iterator.next());
                String elementName = part.getName();
                boolean isTyped = true;
                if (part.getTypeName() != null) {
                    schemaTypeName = part.getTypeName();
                } else if (part.getElementName() != null) {
                    schemaTypeName = part.getElementName();
                    isTyped = false;
                } else {
                    throw new RuntimeException(" Unqualified Message part!");
                }
                Element child = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
                if ("http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
                    prefix = xsdPrefix;
                } else {
                    String uri = schemaTypeName.getNamespaceURI();
                    if (!namespaceImportsMap.containsKey(uri)) {
                        Element namespaceImport = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "import");
                        namespaceImport.setAttribute(NAMESPACE_URI, uri);
                        namespaceImportsMap.put(uri, namespaceImport);
                        prefix = this.getTemporaryNamespacePrefix();
                        namespacePrefixMap.put(uri, prefix);
                    } else {
                        prefix = (String)namespacePrefixMap.get(uri);
                    }
                }
                if (isTyped) {
                    child.setAttribute("name", elementName);
                    child.setAttribute("type", prefix + ":" + schemaTypeName.getLocalPart());
                } else {
                    child.setAttribute("ref", prefix + ":" + schemaTypeName.getLocalPart());
                }
                cmplxTypeSequence.appendChild(child);
            }
            newComplexType.appendChild(cmplxTypeSequence);
            complexTypeElementsMap.put(wsdl4jMessage.getQName(), newComplexType);
            resolvedMessageQNames.add(wsdl4jMessage.getQName());
        }
        String[] inputOperationtNames = inputOperationsMap.keySet().toArray(new String[inputOperationsMap.size()]);
        for (int j = 0; j < inputOperationtNames.length; ++j) {
            String inputOpName = inputOperationtNames[j];
            Element elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", inputOpName);
            QName typeQName2 = ((Message)inputOperationsMap.get(inputOpName)).getQName();
            elementDeclaration.appendChild(((Element)complexTypeElementsMap.get(typeQName2)).cloneNode(true));
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(inputOpName, new QName(namespaceURI, inputOpName, "axis2wrapped"));
        }
        String[] outputOperationtNames = outputOperationsMap.keySet().toArray(new String[outputOperationsMap.size()]);
        for (int j = 0; j < outputOperationtNames.length; ++j) {
            String baseoutputOpName = outputOperationtNames[j];
            String outputOpName = baseoutputOpName + WRAPPED_OUTPUTNAME_SUFFIX;
            Element elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", outputOpName);
            typeQName = ((Message)outputOperationsMap.get(baseoutputOpName)).getQName();
            elementDeclaration.appendChild(((Element)complexTypeElementsMap.get(typeQName)).cloneNode(true));
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(outputOpName, new QName(namespaceURI, outputOpName, "axis2wrapped"));
        }
        String[] faultyOperationtNames = faultyOperationsMap.keySet().toArray(new String[faultyOperationsMap.size()]);
        for (int j = 0; j < faultyOperationtNames.length; ++j) {
            String baseFaultOpName = faultyOperationtNames[j];
            Element elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", baseFaultOpName);
            typeQName = ((Message)faultyOperationsMap.get(baseFaultOpName)).getQName();
            elementDeclaration.appendChild(((Element)complexTypeElementsMap.get(typeQName)).cloneNode(true));
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(baseFaultOpName, new QName(namespaceURI, baseFaultOpName, "axis2wrapped"));
        }
        if (existingSchemaMap.containsKey(namespaceURI)) {
            Element schemaElement = (Element)existingSchemaMap.get(namespaceURI);
            Document ownerDocument = schemaElement.getOwnerDocument();
            String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
            for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
                String s = nameSpaceDeclarationArray[i];
                this.checkAndAddNamespaceDeclarations(s, namespacePrefixMap, schemaElement);
            }
            Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
            for (int i = 0; i < namespaceImports.length; ++i) {
                if (namespaceURI.equals(namespaceImports[i].getAttribute(NAMESPACE_URI))) continue;
                schemaElement.appendChild(ownerDocument.importNode(namespaceImports[i], true));
            }
            Element[] elementDeclarations = elementElementsList.toArray(new Element[elementElementsList.size()]);
            for (int i = 0; i < elementDeclarations.length; ++i) {
                schemaElement.appendChild(ownerDocument.importNode(elementDeclarations[i], true));
            }
            return null;
        }
        Element schemaElement = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "schema");
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + namespacePrefixMap.get(s).toString(), s);
        }
        if (schemaElement.getAttributeNS(XML_NAMESPACE_URI, xsdPrefix).length() == 0) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + xsdPrefix, "http://www.w3.org/2001/XMLSchema");
        }
        schemaElement.setAttributeNS(XML_NAMESPACE_URI, "xmlns:axis2wrapped", namespaceURI);
        schemaElement.setAttribute(TRAGET_NAMESPACE, namespaceURI);
        schemaElement.setAttribute("elementFormDefault", "unqualified");
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            schemaElement.appendChild(namespaceImports[i]);
        }
        Element[] elementDeclarations = elementElementsList.toArray(new Element[elementElementsList.size()]);
        for (int i = 0; i < elementDeclarations.length; ++i) {
            schemaElement.appendChild(elementDeclarations[i]);
        }
        return schemaElement;
    }

    private void checkAndAddNamespaceDeclarations(String namespace, Map prefixMap, Element schemaElement) {
        String prefix = (String)prefixMap.get(namespace);
        String existingURL = schemaElement.getAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix);
        if (existingURL == null) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix, namespace);
        } else if (!existingURL.equals(namespace)) {
            String generatedPrefix = "ns" + prefixCounter++;
            while (prefixMap.containsKey(generatedPrefix)) {
                generatedPrefix = "ns" + prefixCounter++;
            }
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + generatedPrefix, namespace);
            prefixMap.put(generatedPrefix, namespace);
        }
    }

    private void processImports(Definition wsdl4JDefinition, List processedDocuments) {
        Map wsdlImports = wsdl4JDefinition.getImports();
        if (null != wsdlImports && !wsdlImports.isEmpty()) {
            Collection importsCollection = wsdlImports.values();
            Iterator iterator = importsCollection.iterator();
            while (iterator.hasNext()) {
                Vector values = (Vector)iterator.next();
                for (int i = 0; i < values.size(); ++i) {
                    Definition importedDef;
                    Import wsdlImport = (Import)values.elementAt(i);
                    if (wsdlImport.getDefinition() == null || (importedDef = wsdlImport.getDefinition()) == null) continue;
                    String key = importedDef.getDocumentBaseURI();
                    if (key == null) {
                        key = importedDef.getTargetNamespace();
                    }
                    if (processedDocuments.contains(key)) {
                        return;
                    }
                    processedDocuments.add(key);
                    this.processImports(importedDef, processedDocuments);
                    Map namespaces = importedDef.getNamespaces();
                    Iterator keys = namespaces.keySet().iterator();
                    while (keys.hasNext()) {
                        Object key2 = keys.next();
                        if (this.wsdl4jDefinition.getNamespaces().containsValue(namespaces.get(key2))) continue;
                        this.wsdl4jDefinition.getNamespaces().put(key2, namespaces.get(key2));
                    }
                    this.wsdl4jDefinition.getNamespaces().putAll(namespaces);
                    Types t = importedDef.getTypes();
                    if (t != null) {
                        List typesList = t.getExtensibilityElements();
                        for (int j = 0; j < typesList.size(); ++j) {
                            Types types = wsdl4JDefinition.getTypes();
                            if (types == null) {
                                types = wsdl4JDefinition.createTypes();
                                wsdl4JDefinition.setTypes(types);
                            }
                            types.addExtensibilityElement((ExtensibilityElement)typesList.get(j));
                        }
                    }
                    Map messagesMap = importedDef.getMessages();
                    wsdl4JDefinition.getMessages().putAll(messagesMap);
                    Map porttypeMap = importedDef.getPortTypes();
                    wsdl4JDefinition.getPortTypes().putAll(porttypeMap);
                    Map bindingMap = importedDef.getBindings();
                    wsdl4JDefinition.getBindings().putAll(bindingMap);
                    Map serviceMap = importedDef.getServices();
                    wsdl4JDefinition.getServices().putAll(serviceMap);
                    List extElementList = importedDef.getExtensibilityElements();
                    wsdl4JDefinition.getExtensibilityElements().addAll(extElementList);
                }
            }
        }
    }

    private Definition readInTheWSDLFile(InputStream in) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE_KEY, false);
        if (this.customWSLD4JResolver != null) {
            return reader.readWSDL(this.customWSLD4JResolver);
        }
        try {
            doc = XMLUtils.newDocument(in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(this.getBaseUri(), doc);
    }

    private void copyExtensibleElements(List wsdl4jExtensibleElements, Definition wsdl4jDefinition, AxisDescription description, String originOfExtensibilityElements) throws AxisFault {
        Iterator iterator = wsdl4jExtensibleElements.iterator();
        while (iterator.hasNext()) {
            SOAPBinding soapBinding;
            Part msgPart;
            Message msg;
            Boolean required;
            SOAPHeaderMessage headerMessage;
            SOAP12Header soapHeader;
            SOAP12Operation soapOperation;
            SOAP12Address soapAddress;
            AxisOperation axisOperation;
            ExtensibilityElement wsdl4jElement = (ExtensibilityElement)iterator.next();
            if (wsdl4jElement instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement unknown = (UnknownExtensibilityElement)wsdl4jElement;
                if (WSDLConstants.WSDL11Constants.POLICY.equals(unknown.getElementType())) {
                    Policy policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement());
                    this.addPolicy(description, originOfExtensibilityElements, policy);
                    continue;
                }
                if (WSDLConstants.WSDL11Constants.POLICY_REFERENCE.equals(unknown.getElementType())) {
                    PolicyReference policyReference = (PolicyReference)PolicyUtil.getPolicyComponent(unknown.getElement());
                    this.addPolicyRef(description, originOfExtensibilityElements, policyReference);
                    continue;
                }
                if (AddressingConstants.Final.WSAW_USING_ADDRESSING.equals(unknown.getElementType()) || AddressingConstants.Submission.WSAW_USING_ADDRESSING.equals(unknown.getElementType())) {
                    if (!originOfExtensibilityElements.equals(PORT) && !originOfExtensibilityElements.equals(BINDING)) continue;
                    if (Boolean.TRUE.equals(unknown.getRequired())) {
                        this.axisService.setWSAddressingFlag("required");
                        continue;
                    }
                    this.axisService.setWSAddressingFlag("optional");
                    continue;
                }
                if (!AddressingConstants.Final.WSAW_ANONYMOUS.equals(unknown.getElementType()) || !originOfExtensibilityElements.equals(BINDING_OPERATION)) continue;
                axisOperation = (AxisOperation)description;
                if (unknown.getElement().getFirstChild() == null || unknown.getElement().getFirstChild().getNodeType() != 3) continue;
                String anonymousValue = unknown.getElement().getFirstChild().getNodeValue();
                AddressingHelper.setAnonymousParameterValue(axisOperation, anonymousValue);
                continue;
            }
            if (wsdl4jElement instanceof SOAP12Address) {
                soapAddress = (SOAP12Address)wsdl4jElement;
                this.axisService.setEndpoint(soapAddress.getLocationURI());
                continue;
            }
            if (wsdl4jElement instanceof SOAPAddress) {
                soapAddress = (SOAPAddress)wsdl4jElement;
                this.axisService.setEndpoint(soapAddress.getLocationURI());
                continue;
            }
            if (wsdl4jElement instanceof Schema) {
                Schema schema = (Schema)wsdl4jElement;
                this.axisService.addSchema(this.getXMLSchema(schema.getElement(), schema.getDocumentBaseURI()));
                continue;
            }
            if (wsdl4jElement instanceof SOAP12Operation) {
                soapOperation = (SOAP12Operation)wsdl4jElement;
                if (!(description instanceof AxisOperation)) continue;
                axisOperation = (AxisOperation)description;
                if (soapOperation.getStyle() != null) {
                    axisOperation.setStyle(soapOperation.getStyle());
                }
                axisOperation.setSoapAction(soapOperation.getSoapActionURI());
                continue;
            }
            if (wsdl4jElement instanceof SOAPOperation) {
                soapOperation = (SOAPOperation)wsdl4jElement;
                if (!(description instanceof AxisOperation)) continue;
                axisOperation = (AxisOperation)description;
                if (soapOperation.getStyle() != null) {
                    axisOperation.setStyle(soapOperation.getStyle());
                }
                axisOperation.setSoapAction(soapOperation.getSoapActionURI());
                continue;
            }
            if (wsdl4jElement instanceof SOAP12Header) {
                soapHeader = (SOAP12Header)wsdl4jElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (null != required) {
                    headerMessage.setRequired(required);
                }
                if (null != wsdl4jDefinition) {
                    msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisMessage)) continue;
                ((AxisMessage)description).addSoapHeader(headerMessage);
                continue;
            }
            if (wsdl4jElement instanceof SOAPHeader) {
                soapHeader = (SOAPHeader)wsdl4jElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (null != required) {
                    headerMessage.setRequired(required);
                }
                if (null != wsdl4jDefinition) {
                    msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisMessage)) continue;
                ((AxisMessage)description).addSoapHeader(headerMessage);
                continue;
            }
            if (wsdl4jElement instanceof SOAPBinding) {
                soapBinding = (SOAPBinding)wsdl4jElement;
                this.style = soapBinding.getStyle();
                this.axisService.setSoapNsUri(soapBinding.getElementType().getNamespaceURI());
                continue;
            }
            if (!(wsdl4jElement instanceof SOAP12Binding)) continue;
            soapBinding = (SOAP12Binding)wsdl4jElement;
            this.style = soapBinding.getStyle();
            this.axisService.setSoapNsUri(soapBinding.getElementType().getNamespaceURI());
        }
    }

    private void addPolicy(AxisDescription description, String originOfExtensibilityElements, Policy policy) {
        if (description instanceof AxisService) {
            if (SERVICE.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(6, policy);
            } else if (PORT.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(7, policy);
            } else if (BINDING.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(9, policy);
            }
        } else if (description instanceof AxisOperation) {
            if (PORT_TYPE_OPERATION.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(10, policy);
            } else {
                description.getPolicyInclude().addPolicyElement(11, policy);
            }
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(12, policy);
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(14, policy);
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(13, policy);
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(15, policy);
        }
    }

    private void addPolicyRef(AxisDescription description, String originOfExtensibilityElements, PolicyReference policyRefElement) {
        if (description instanceof AxisService) {
            if (SERVICE.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(6, policyRefElement);
            } else if (PORT.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(7, policyRefElement);
            } else if (BINDING.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(9, policyRefElement);
            }
        } else if (description instanceof AxisOperation) {
            if (PORT_TYPE_OPERATION.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(10, policyRefElement);
            } else {
                description.getPolicyInclude().addPolicyRefElement(9, policyRefElement);
            }
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(12, policyRefElement);
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(14, policyRefElement);
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(13, policyRefElement);
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(15, policyRefElement);
        }
    }

    private List findWrappableOperations(Binding binding) {
        boolean isRPC = false;
        boolean isSOAPBinding = false;
        List extElements = binding.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            if (!(extElements.get(i) instanceof SOAPBinding)) continue;
            isSOAPBinding = true;
            SOAPBinding soapBinding = (SOAPBinding)extElements.get(i);
            if (!RPC_STYLE.equals(soapBinding.getStyle())) break;
            isRPC = true;
            break;
        }
        if (!isSOAPBinding) {
            return new ArrayList();
        }
        ArrayList<Operation> returnList = new ArrayList<Operation>();
        Iterator bindingOperationsIterator = binding.getBindingOperations().iterator();
        while (bindingOperationsIterator.hasNext()) {
            BindingOperation bindingOp = (BindingOperation)bindingOperationsIterator.next();
            String style = this.getSOAPStyle(bindingOp);
            if (style == null) {
                if (!isRPC) continue;
                returnList.add(bindingOp.getOperation());
                continue;
            }
            if (!RPC_STYLE.equals(style)) continue;
            returnList.add(bindingOp.getOperation());
        }
        this.wrappableOperations = returnList;
        return returnList;
    }

    private String getMEP(Operation operation) throws Exception {
        OperationType operationType = operation.getStyle();
        if (this.isServerSide) {
            if (null != operationType) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    return "http://www.w3.org/2004/08/wsdl/in-out";
                }
                if (operationType.equals(OperationType.ONE_WAY)) {
                    if (operation.getFaults().size() > 0) {
                        return "http://www.w3.org/2004/08/wsdl/robust-in-only";
                    }
                    return "http://www.w3.org/2004/08/wsdl/in-only";
                }
                if (operationType.equals(OperationType.NOTIFICATION)) {
                    return "http://www.w3.org/2004/08/wsdl/out-only";
                }
                if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    return "http://www.w3.org/2004/08/wsdl/out-in";
                }
                throw new Exception("Cannot Determine the MEP");
            }
        } else if (null != operationType) {
            if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                return "http://www.w3.org/2004/08/wsdl/out-in";
            }
            if (operationType.equals(OperationType.ONE_WAY)) {
                return "http://www.w3.org/2004/08/wsdl/out-only";
            }
            if (operationType.equals(OperationType.NOTIFICATION)) {
                return "http://www.w3.org/2004/08/wsdl/in-only";
            }
            if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                return "http://www.w3.org/2004/08/wsdl/in-out";
            }
            throw new Exception("Cannot Determine the MEP");
        }
        throw new Exception("Cannot Determine the MEP");
    }

    private void copyExtensionAttributes(Map extAttributes, AxisDescription description, String origin) {
        Iterator iterator = extAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            QName value;
            String policyURIs;
            QName key = (QName)iterator.next();
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(key.getNamespaceURI()) || !"PolicyURIs".equals(key.getLocalPart()) || (policyURIs = (value = (QName)extAttributes.get(key)).getLocalPart()).length() == 0) continue;
            String[] uris = policyURIs.split(" ");
            for (int i = 0; i < uris.length; ++i) {
                PolicyReference ref = new PolicyReference();
                ref.setURI(uris[i]);
                if (!PORT_TYPE.equals(origin)) continue;
                PolicyInclude include = description.getPolicyInclude();
                include.addPolicyRefElement(8, ref);
            }
        }
    }

    private void processPoliciesInDefintion(Definition definition) {
        List extElements = definition.getExtensibilityElements();
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            Policy policy;
            String key;
            UnknownExtensibilityElement unknown;
            ExtensibilityElement extElement = (ExtensibilityElement)iterator.next();
            if (!(extElement instanceof UnknownExtensibilityElement) || !WSDLConstants.WSDL11Constants.POLICY.equals((unknown = (UnknownExtensibilityElement)extElement).getElementType()) || (key = (policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement())).getName()) == null && (key = policy.getId()) == null) continue;
            this.registry.register(key, policy);
        }
    }

    public static class WSDLProcessingException
    extends RuntimeException {
        public WSDLProcessingException() {
        }

        public WSDLProcessingException(String message) {
            super(message);
        }

        public WSDLProcessingException(Throwable cause) {
            super(cause);
        }

        public WSDLProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

