/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.net.URL;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.CallbackReceiver;

public class ServiceClient {
    public static final String ANON_SERVICE = "anonService";
    public static final QName ANON_OUT_ONLY_OP = new QName("anonOutonlyOp");
    public static final QName ANON_ROBUST_OUT_ONLY_OP = new QName("anonRobustOp");
    public static final QName ANON_OUT_IN_OP = new QName("anonOutInOp");
    private AxisService axisService;
    private AxisConfiguration axisConfig;
    private ConfigurationContext configContext;
    private ServiceContext serviceContext;
    private Options options = new Options();
    private Options overrideOptions;
    private ArrayList headers;
    private boolean createConfigCtx;

    public ServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.configureServiceClient(configContext, axisService);
    }

    private void configureServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.initializeTransports(configContext);
        this.axisConfig = this.configContext.getAxisConfiguration();
        this.axisService = axisService != null ? axisService : this.createAnonymousService();
        if (this.axisConfig.getService(this.axisService.getName()) != null) {
            throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", this.axisService.getName()));
        }
        this.axisService.setClientSide(true);
        this.axisConfig.addService(this.axisService);
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)this.axisService.getParent();
        ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, axisServiceGroup);
        this.serviceContext = sgc.getServiceContext(this.axisService);
    }

    public ServiceClient(ConfigurationContext configContext, Definition wsdl4jDefinition, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdl4jDefinition, wsdlServiceName, portName, this.options));
    }

    public ServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdlURL, wsdlServiceName, portName, this.options));
    }

    private void initializeTransports(ConfigurationContext configContext) throws AxisFault {
        if (configContext != null) {
            this.configContext = configContext;
            ListenerManager transportManager = configContext.getListenerManager();
            if (transportManager == null) {
                transportManager = new ListenerManager();
                transportManager.init(this.configContext);
            }
        } else if (ListenerManager.defaultConfigurationContext == null) {
            this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            ListenerManager transportManager = new ListenerManager();
            transportManager.init(this.configContext);
            this.createConfigCtx = true;
        } else {
            this.configContext = ListenerManager.defaultConfigurationContext;
        }
    }

    public ServiceClient() throws AxisFault {
        this(null, null);
    }

    private AxisService createAnonymousService() {
        AxisService axisService = new AxisService(ANON_SERVICE + this.hashCode() + System.currentTimeMillis());
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ANON_ROBUST_OUT_ONLY_OP);
        axisService.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ANON_OUT_ONLY_OP);
        axisService.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ANON_OUT_IN_OP);
        axisService.addOperation(outInOperation);
        return axisService;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOverrideOptions(Options overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Options getOverrideOptions() {
        return this.overrideOptions;
    }

    public void engageModule(QName moduleName) throws AxisFault {
        AxisModule module = this.axisConfig.getModule(moduleName);
        if (module == null) {
            throw new AxisFault("Unable to engage module : " + moduleName.getLocalPart());
        }
        this.axisService.engageModule(module, this.axisConfig);
    }

    public void disengageModule(QName moduleName) {
        AxisModule module = this.axisConfig.getModule(moduleName);
        if (module != null) {
            this.axisService.disengageModule(module);
        }
    }

    public void addHeader(OMElement header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void addHeader(SOAPHeaderBlock header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void addStringHeader(QName headerName, String headerText) throws AxisFault {
        if (headerName.getNamespaceURI() == null || "".equals(headerName.getNamespaceURI())) {
            throw new AxisFault("Failed to add string header , you have to have namespaceURI for the QName");
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(headerName, null);
        omElement.setText(headerText);
        this.addHeader(omElement);
    }

    public void sendRobust(OMElement elem) throws AxisFault {
        this.sendRobust(ANON_ROBUST_OUT_ONLY_OP, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendRobust(QName operation, OMElement elem) throws AxisFault {
        if (this.options.isUseSeparateListener()) {
            long timeout;
            SyncCallBack callback = new SyncCallBack();
            this.sendReceiveNonBlocking(operation, elem, callback);
            long waitTime = timeout = this.options.getTimeOutInMilliSeconds();
            long startTime = System.currentTimeMillis();
            SyncCallBack syncCallBack = callback;
            synchronized (syncCallBack) {
                while (!callback.isComplete() && waitTime >= 0L) {
                    try {
                        callback.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waitTime = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            SOAPEnvelope envelope = callback.envelope;
            if (envelope != null) {
                envelope.build();
                if (!envelope.getBody().hasFault()) return;
                SOAPFault soapFault = envelope.getBody().getFault();
                throw new AxisFault(soapFault.getCode(), soapFault.getReason(), soapFault.getNode(), soapFault.getRole(), soapFault.getDetail());
            }
            if (callback.error instanceof AxisFault) {
                throw (AxisFault)callback.error;
            }
            if (callback.error != null) {
                throw new AxisFault(callback.error);
            }
            if (callback.isComplete()) return;
        }
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    public void fireAndForget(OMElement elem) throws AxisFault {
        this.fireAndForget(ANON_OUT_ONLY_OP, elem);
    }

    public void fireAndForget(QName operation, OMElement elem) throws AxisFault {
        OperationClient mepClient = this.createClient(operation);
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OMElement sendReceive(OMElement elem) throws AxisFault {
        return this.sendReceive(ANON_OUT_IN_OP, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendReceive(QName operationQName, OMElement xmlPayload) throws AxisFault {
        if (this.options.isUseSeparateListener()) {
            long timeout;
            SyncCallBack callback = new SyncCallBack();
            this.sendReceiveNonBlocking(operationQName, xmlPayload, callback);
            long waitTime = timeout = this.options.getTimeOutInMilliSeconds();
            long startTime = System.currentTimeMillis();
            SyncCallBack syncCallBack = callback;
            synchronized (syncCallBack) {
                while (!callback.isComplete() && waitTime >= 0L) {
                    try {
                        callback.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waitTime = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            if (callback.envelope != null) {
                return callback.envelope.getBody().getFirstElement();
            }
            if (callback.error instanceof AxisFault) {
                throw (AxisFault)callback.error;
            }
            if (callback.error != null) {
                throw new AxisFault(callback.error);
            }
            if (!callback.isComplete()) {
                throw new AxisFault(Messages.getMessage("responseTimeOut"));
            }
            throw new AxisFault(Messages.getMessage("callBackCompletedWithError"));
        }
        MessageContext messageContext = new MessageContext();
        this.fillSOAPEnvelope(messageContext, xmlPayload);
        OperationClient operationClient = this.createClient(operationQName);
        operationClient.addMessageContext(messageContext);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        return response.getEnvelope().getBody().getFirstElement();
    }

    public void sendReceiveNonBlocking(OMElement elem, Callback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, Callback callback) throws AxisFault {
        MessageReceiver messageReceiver;
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        if (this.options.isUseSeparateListener() && ((messageReceiver = this.axisService.getOperation(operation).getMessageReceiver()) == null || !(messageReceiver instanceof CallbackReceiver))) {
            CallbackReceiver callbackReceiver = new CallbackReceiver();
            this.axisService.getOperation(operation).setMessageReceiver(callbackReceiver);
        }
        mepClient.execute(false);
    }

    public OperationClient createClient(QName operationQName) throws AxisFault {
        AxisOperation axisOperation = this.axisService.getOperation(operationQName);
        if (axisOperation == null) {
            throw new AxisFault(Messages.getMessage("operationnotfound", operationQName.getLocalPart()));
        }
        OperationClient operationClient = axisOperation.createClient(this.serviceContext, this.options);
        if (this.overrideOptions != null) {
            this.overrideOptions.setParent(operationClient.getOptions());
            operationClient.setOptions(this.overrideOptions);
        }
        return operationClient;
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    private void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload) throws AxisFault {
        messageContext.setServiceContext(this.serviceContext);
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        messageContext.setEnvelope(envelope);
    }

    public void addHeadersToEnvelope(SOAPEnvelope envelope) {
        if (this.headers != null) {
            SOAPHeader soapHeader = envelope.getHeader();
            for (int i = 0; i < this.headers.size(); ++i) {
                soapHeader.addChild((OMNode)((OMElement)this.headers.get(i)));
            }
        }
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        return this.serviceContext.getMyEPR(transport);
    }

    public EndpointReference getTargetEPR() {
        return this.serviceContext.getTargetEPR();
    }

    public void setTargetEPR(EndpointReference targetEpr) {
        this.serviceContext.setTargetEPR(targetEpr);
        this.options.setTo(targetEpr);
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    public void cleanup() throws AxisFault {
        if (!this.createConfigCtx) {
            String serviceGroupName = ((AxisServiceGroup)this.axisService.getParent()).getServiceGroupName();
            AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
            AxisServiceGroup asg = axisConfiguration.getServiceGroup(serviceGroupName);
            if (asg != null) {
                axisConfiguration.removeServiceGroup(serviceGroupName);
            }
        } else {
            this.configContext.getListenerManager().stop();
        }
    }

    private class SyncCallBack
    extends Callback {
        private SOAPEnvelope envelope;
        private MessageContext msgctx;
        private Exception error;

        private SyncCallBack() {
        }

        public void onComplete(AsyncResult result) {
            this.envelope = result.getResponseEnvelope();
            this.envelope.buildWithAttachments();
            this.msgctx = result.getResponseMessageContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComplete(boolean complete) {
            super.setComplete(complete);
            SyncCallBack syncCallBack = this;
            synchronized (syncCallBack) {
                this.notify();
            }
        }

        public void onError(Exception e) {
            this.error = e;
        }

        public MessageContext getMsgctx() {
            return this.msgctx;
        }
    }
}

