/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.AbstractJSONDataSource;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJSONMessageFormatter
implements MessageFormatter {
    private final Class<? extends AbstractJSONDataSource> dataSourceClass;

    public AbstractJSONMessageFormatter(Class<? extends AbstractJSONDataSource> dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
    }

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String contentType = (String)msgCtxt.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)msgCtxt.getProperty("messageType");
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        String jsonToWrite = this.getStringToWrite(element);
        if (jsonToWrite != null) {
            return jsonToWrite.getBytes();
        }
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            XMLStreamWriter jsonWriter = this.getJSONWriter(bytesOut, format, msgCtxt);
            element.serializeAndConsume(jsonWriter);
            jsonWriter.writeEndDocument();
            return bytesOut.toByteArray();
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new AxisFault("Mapped formatted JSON with namespaces are not supported in Axis2. Make sure that your request doesn't include namespaces or use the Badgerfish convention");
        }
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        return null;
    }

    private XMLStreamWriter getJSONWriter(OutputStream outStream, OMOutputFormat format, MessageContext messageContext) throws AxisFault, XMLStreamException {
        try {
            return this.getJSONWriter(new OutputStreamWriter(outStream, format.getCharSetEncoding()), messageContext);
        }
        catch (UnsupportedEncodingException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
    }

    protected abstract XMLStreamWriter getJSONWriter(Writer var1, MessageContext var2) throws XMLStreamException;

    private String getStringToWrite(OMElement element) {
        if (element instanceof OMSourcedElement) {
            return (String)((OMSourcedElement)element).getObject(this.dataSourceClass);
        }
        return null;
    }

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        try {
            String jsonToWrite;
            if (element instanceof SOAPFault) {
                SOAPFault fault = (SOAPFault)element;
                OMElement element2 = element.getOMFactory().createOMElement("Fault", null);
                element2.setText(fault.toString());
                element = element2;
            }
            if ((jsonToWrite = this.getStringToWrite(element)) != null) {
                out.write(jsonToWrite.getBytes());
            } else {
                XMLStreamWriter jsonWriter = this.getJSONWriter(out, format, msgCtxt);
                jsonWriter.writeStartDocument();
                element.serializeAndConsume(jsonWriter);
                jsonWriter.writeEndDocument();
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        String httpMethod = (String)msgCtxt.getProperty("HTTP_METHOD");
        OMElement dataOut = msgCtxt.getEnvelope().getBody().getFirstElement();
        if (dataOut != null && httpMethod != null && "GET".equalsIgnoreCase(httpMethod)) {
            try {
                String jsonString = this.getStringToWrite(dataOut);
                if (jsonString == null) {
                    StringWriter out = new StringWriter();
                    XMLStreamWriter jsonWriter = this.getJSONWriter(out, msgCtxt);
                    jsonWriter.writeStartDocument();
                    dataOut.serializeAndConsume(jsonWriter);
                    jsonWriter.writeEndDocument();
                    jsonString = out.toString();
                }
                jsonString = URIEncoderDecoder.quoteIllegal((String)jsonString, (String)"-._~!$&()*,;=:@?/%");
                String param = "query=" + jsonString;
                String returnURLFile = targetURL.getFile() + "?" + param;
                return new URL(targetURL.getProtocol(), targetURL.getHost(), targetURL.getPort(), returnURLFile);
            }
            catch (MalformedURLException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return targetURL;
    }
}

