/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.java2wsdl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLMojo
extends AbstractMojo {
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String COMMA = ",";
    private MavenProject project;
    private String className;
    private String targetNamespace;
    private String targetNamespacePrefix;
    private String schemaTargetNamespace;
    private String schemaTargetNamespacePrefix;
    private String serviceName;
    private String outputFileName;
    private String style;
    private String use;
    private String wsdlVersion;
    private String nsGenClassName;
    private String schemaGenClassName;
    private String locationUri;
    private String attrFormDefault;
    private String elementFormDefault;
    private String docLitBare;
    private String[] extraClasses;
    private Properties package2Namespace;

    private void addToOptionMap(Map map, String option, String value) {
        this.addToOptionMap(map, option, new String[]{value});
    }

    private void addToOptionMap(Map map, String option, String[] value) {
        if (value != null) {
            map.put(option, new Java2WSDLCommandLineOption(option, value));
        }
    }

    private void addToOptionMap(Map map, String option, ArrayList values) {
        if (values != null && !values.isEmpty()) {
            map.put(option, new Java2WSDLCommandLineOption(option, values));
        }
    }

    private Map fillOptionMap() throws MojoFailureException {
        File file;
        File dir;
        HashMap optionMap = new HashMap();
        if (this.className == null) {
            throw new MojoFailureException("You must specify a classname");
        }
        this.addToOptionMap(optionMap, "cn", this.className);
        this.addToOptionMap(optionMap, "tn", this.targetNamespace);
        this.addToOptionMap(optionMap, "tp", this.targetNamespacePrefix);
        this.addToOptionMap(optionMap, "stn", this.schemaTargetNamespace);
        this.addToOptionMap(optionMap, "stp", this.schemaTargetNamespacePrefix);
        this.addToOptionMap(optionMap, "sn", this.serviceName);
        File outputFile = new File(this.outputFileName);
        if (!outputFile.isAbsolute()) {
            outputFile = new File(this.project.getBasedir(), this.outputFileName);
        }
        if (!(dir = outputFile.getParentFile()).isDirectory()) {
            dir.mkdirs();
        }
        this.addToOptionMap(optionMap, "o", dir.getPath());
        this.addToOptionMap(optionMap, "of", outputFile.getName());
        Artifact artifact = this.project.getArtifact();
        Set artifacts = this.project.getArtifacts();
        String[] artifactFileNames = new String[artifacts.size() + (artifact == null ? 0 : 1)];
        int j = 0;
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            artifactFileNames[j] = ((Artifact)i.next()).getFile().getAbsolutePath();
            ++j;
        }
        if (artifact != null && (file = artifact.getFile()) != null) {
            artifactFileNames[j] = file.getAbsolutePath();
        }
        this.addToOptionMap(optionMap, "cp", artifactFileNames);
        if (this.style != null) {
            this.addToOptionMap(optionMap, "st", this.style);
        }
        if (this.use != null) {
            this.addToOptionMap(optionMap, "u", this.use);
        }
        if (this.wsdlVersion != null) {
            this.addToOptionMap(optionMap, "wv", this.wsdlVersion);
        }
        if (this.docLitBare != null) {
            this.addToOptionMap(optionMap, "dlb", this.docLitBare);
        }
        if (this.locationUri != null) {
            this.addToOptionMap(optionMap, "l", this.locationUri);
        }
        if (this.nsGenClassName != null) {
            this.addToOptionMap(optionMap, "nsg", this.nsGenClassName);
        }
        if (this.schemaGenClassName != null) {
            this.addToOptionMap(optionMap, "sg", this.schemaGenClassName);
        }
        if (this.attrFormDefault != null) {
            this.addToOptionMap(optionMap, "afd", this.attrFormDefault);
        }
        if (this.elementFormDefault != null) {
            this.addToOptionMap(optionMap, "efd", this.elementFormDefault);
        }
        if (this.extraClasses != null && this.extraClasses.length > 0) {
            this.addToOptionMap(optionMap, "xc", this.extraClasses);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.package2Namespace != null) {
            for (Map.Entry<Object, Object> entry : this.package2Namespace.entrySet()) {
                String packageName = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                list.add(OPEN_BRACKET + packageName + COMMA + namespace + CLOSE_BRACKET);
            }
        }
        this.addToOptionMap(optionMap, "p2n", list);
        return optionMap;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map commandLineOptions = this.fillOptionMap();
        try {
            new Java2WSDLCodegenEngine(commandLineOptions).generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

