/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JAXBRIExtension
extends AbstractDBProcessingExtension {
    public static final String SCHEMA_FOLDER = "schemas";
    public static String MAPPINGS = "mappings";
    public static String MAPPING = "mapping";
    public static String MESSAGE = "message";
    public static String JAVA_NAME = "javaclass";
    public static final String MAPPING_FOLDER = "Mapping";
    public static final String MAPPER_FILE_NAME = "mapper";
    public static final String SCHEMA_PATH = "/org/apache/axis2/wsdl/codegen/schema/";
    public static final String JAXB_RI_API_CLASS = "javax.xml.bind.JAXBContext";
    public static final String JAXB_RI_IMPL_CLASS = "com.sun.xml.bind.v2.JAXBContextFactory";
    public static final String JAXB_RI_XJC_CLASS = "com.sun.tools.xjc.api.XJC";
    public static final String JAXB_RI_UTILITY_CLASS = "org.apache.axis2.jaxbri.CodeGenerationUtility";
    public static final String JAXB_RI_PROCESS_METHOD = "processSchemas";

    @Override
    public void engage(CodeGenConfiguration configuration) {
        if (this.testFallThrough(configuration.getDatabindingType())) {
            return;
        }
        try {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                cl.loadClass(JAXB_RI_API_CLASS);
                cl.loadClass(JAXB_RI_IMPL_CLASS);
                cl.loadClass(JAXB_RI_XJC_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JAX-B RI JARs not on classpath");
            }
            Class<?> clazz = null;
            try {
                clazz = JAXBRIExtension.class.getClassLoader().loadClass(JAXB_RI_UTILITY_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JAX-B RI binding extension not in classpath");
            }
            Method method = clazz.getMethod(JAXB_RI_PROCESS_METHOD, List.class, Element[].class, CodeGenConfiguration.class);
            ArrayList schemas = new ArrayList();
            List<AxisService> axisServices = configuration.getAxisServices();
            AxisService axisService2 = null;
            for (AxisService axisService2 : axisServices) {
                schemas.addAll(axisService2.getSchema());
            }
            Element[] additionalSchemas = this.loadAdditionalSchemas();
            TypeMapper mapper = (TypeMapper)method.invoke(null, schemas, additionalSchemas, configuration);
            configuration.setTypeMapper(mapper);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Element[] loadAdditionalSchemas() {
        Element[] schemaElements;
        String[] schemaNames = ConfigPropertyFileLoader.getThirdPartySchemaNames();
        try {
            int i;
            ArrayList<Element> additionalSchemaElements = new ArrayList<Element>();
            DocumentBuilder documentBuilder = this.getNamespaceAwareDocumentBuilder();
            for (i = 0; i < schemaNames.length; ++i) {
                if ("".equals(schemaNames[i].trim())) continue;
                InputStream schemaStream = this.getClass().getResourceAsStream(SCHEMA_PATH + schemaNames[i]);
                Document doc = documentBuilder.parse(schemaStream);
                additionalSchemaElements.add(doc.getDocumentElement());
            }
            schemaElements = new Element[additionalSchemaElements.size()];
            for (i = 0; i < additionalSchemaElements.size(); ++i) {
                schemaElements[i] = (Element)additionalSchemaElements.get(i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(CodegenMessages.getMessage("extension.additionalSchemaFailure"), e);
        }
        return schemaElements;
    }

    private DocumentBuilder getNamespaceAwareDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }
}

