/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;

public class SimpleDBExtension
extends AbstractDBProcessingExtension {
    public void engage() {
        if (this.testFallThrough(this.configuration.getDatabindingType())) {
            return;
        }
        try {
            ArrayList schemaList = this.configuration.getAxisService().getSchema();
            if (schemaList == null || schemaList.isEmpty()) {
                this.configuration.setTypeMapper(new DefaultTypeMapper());
                return;
            }
            CompilerOptions options = new CompilerOptions();
            this.populateDefaultOptions(options);
            this.populateUserparameters(options);
            SchemaCompiler schemaCompiler = new SchemaCompiler(options);
            schemaCompiler.compile(schemaList);
            JavaTypeMapper mapper = new JavaTypeMapper();
            if (options.isWriteOutput()) {
                HashMap processedMap = schemaCompiler.getProcessedElementMap();
                Iterator processedkeys = processedMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    QName qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
                }
            } else {
                QName qNameKey;
                Map processedModelMap = schemaCompiler.getProcessedModelMap();
                Iterator processedkeys = processedModelMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingObject(qNameKey, processedModelMap.get(qNameKey));
                }
                HashMap processedMap = schemaCompiler.getProcessedElementMap();
                processedkeys = processedMap.keySet().iterator();
                while (processedkeys.hasNext()) {
                    qNameKey = (QName)processedkeys.next();
                    mapper.addTypeMappingName(qNameKey, processedMap.get(qNameKey).toString());
                }
                this.configuration.putProperty("externalTemplate", schemaCompiler.getCompilerProperties().getProperty("schema.bean.writer.template"));
            }
            this.configuration.setTypeMapper(mapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void populateUserparameters(CompilerOptions options) {
        String packageName;
        Map propertyMap = this.configuration.getProperties();
        if (propertyMap.containsKey("w")) {
            if (Boolean.valueOf(propertyMap.get("w").toString()).booleanValue()) {
                options.setWrapClasses(true);
            } else {
                options.setWrapClasses(false);
            }
        }
        if (propertyMap.containsKey("r")) {
            if (Boolean.valueOf(propertyMap.get("r").toString()).booleanValue()) {
                options.setWriteOutput(true);
            } else {
                options.setWriteOutput(false);
            }
        }
        if (propertyMap.containsKey("p") && ((packageName = (String)propertyMap.get("p")) != null || !"".equals(packageName))) {
            options.setPackageName(packageName);
        }
    }

    private void populateDefaultOptions(CompilerOptions options) {
        File outputDir = new File(this.configuration.getOutputLocation(), "src");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        options.setOutputLocation(outputDir);
        options.setNs2PackageMap(this.configuration.getUri2PackageNameMap() == null ? new HashMap() : this.configuration.getUri2PackageNameMap());
        if (this.configuration.isServerSide()) {
            options.setWrapClasses(false);
            options.setWriteOutput(true);
        } else {
            options.setWrapClasses(this.configuration.isPackClasses());
            options.setWriteOutput(!this.configuration.isPackClasses());
        }
    }
}

