/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.aar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.axis2.maven2.aar.AbstractAarMojo;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.maven.plugin.MojoExecutionException;

public class DeployAarMojo
extends AbstractAarMojo {
    private static final String LOGIN_FAILED_ERROR_MESSAGE = "Invalid auth credentials!";
    private URL axis2AdminConsoleURL;
    private String axis2AdminUser;
    private String axis2AdminPassword;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Deploying AAR artifact " + this.project.getArtifact().getFile() + " to Axis2 Web Console " + this.axis2AdminConsoleURL));
        try {
            this.deploy(this.project.getArtifact().getFile());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error deploying aar", e);
        }
    }

    private void deploy(File aarFile) throws MojoExecutionException, IOException, HttpException {
        if (this.axis2AdminConsoleURL == null) {
            throw new MojoExecutionException("No Axis2 administrative console URL provided.");
        }
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        URL axis2AdminConsoleLoginURL = new URL(this.axis2AdminConsoleURL.toString() + "/login");
        this.getLog().debug((CharSequence)("Logging into Axis2 Admin Web Console " + axis2AdminConsoleLoginURL + " using user ID " + this.axis2AdminUser));
        PostMethod post = new PostMethod(axis2AdminConsoleLoginURL.toString());
        NameValuePair[] nvps = new NameValuePair[]{new NameValuePair("userName", this.axis2AdminUser), new NameValuePair("password", this.axis2AdminPassword)};
        post.setRequestBody(nvps);
        int status = client.executeMethod((HttpMethod)post);
        if (status != 200) {
            throw new MojoExecutionException("Failed to log in");
        }
        if (post.getResponseBodyAsString().indexOf(LOGIN_FAILED_ERROR_MESSAGE) != -1) {
            throw new MojoExecutionException("Failed to log into Axis2 administration web console using credentials");
        }
        URL axis2AdminConsoleUploadURL = new URL(this.axis2AdminConsoleURL.toString() + "/upload");
        this.getLog().debug((CharSequence)("Uploading AAR to Axis2 Admin Web Console " + axis2AdminConsoleUploadURL));
        post = new PostMethod(axis2AdminConsoleUploadURL.toString());
        Part[] parts = new Part[]{new FilePart(this.project.getArtifact().getFile().getName(), this.project.getArtifact().getFile())};
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
        status = client.executeMethod((HttpMethod)post);
        if (status != 200) {
            throw new MojoExecutionException("Failed to log in");
        }
        URL axis2AdminConsoleLogoutURL = new URL(this.axis2AdminConsoleURL.toString() + "/logout");
        this.getLog().debug((CharSequence)("Logging out of Axis2 Admin Web Console " + axis2AdminConsoleLogoutURL));
        GetMethod get = new GetMethod(axis2AdminConsoleLogoutURL.toString());
        status = client.executeMethod((HttpMethod)get);
        if (status != 200) {
            throw new MojoExecutionException("Failed to log out");
        }
    }
}

