/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Scope;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.model.wsdd.ArrayMapping;
import org.apache.axis.model.wsdd.Deployment;
import org.apache.axis.model.wsdd.Fault;
import org.apache.axis.model.wsdd.OperationParameter;
import org.apache.axis.model.wsdd.ParameterMode;
import org.apache.axis.model.wsdd.Service;
import org.apache.axis.model.wsdd.TypeMapping;
import org.apache.axis.model.wsdd.WSDDFactory;
import org.apache.axis.model.wsdd.WSDDUtil;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;

public class JavaDeployWriter
extends JavaWriter {
    protected static Log log = LogFactory.getLog((String)JavaDeployWriter.class.getName());
    protected Definition definition;
    protected SymbolTable symbolTable;
    protected Emitter emitter;
    Use use = Use.DEFAULT;
    private static final Map mepStrings = new HashMap();

    public JavaDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "deploy");
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        if (this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected String getFileName() {
        String dir = this.emitter.getNamespaces().getAsDir(this.definition.getTargetNamespace());
        return dir + "deploy.wsdd";
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        pw.println(Messages.getMessage((String)"deploy00"));
        pw.println(Messages.getMessage((String)"deploy02"));
        pw.println(Messages.getMessage((String)"deploy03"));
        pw.println(Messages.getMessage((String)"deploy05"));
        pw.println(Messages.getMessage((String)"deploy06"));
        pw.println(Messages.getMessage((String)"deploy07"));
        pw.println(Messages.getMessage((String)"deploy09"));
        pw.println();
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Deployment deployment = WSDDFactory.INSTANCE.createDeployment();
        this.writeDeployServices(deployment);
        WSDDUtil.save((Deployment)deployment, (Writer)pw);
    }

    protected void writeDeployServices(Deployment deployment) throws IOException {
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            javax.wsdl.Service myService = (javax.wsdl.Service)mapIterator.next();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                this.writeDeployPort(deployment, myPort, myService, bEntry);
            }
        }
    }

    protected void writeDeployTypes(Service service, Binding binding, boolean hasLiteral, boolean hasMIME, Use use) throws IOException {
        if (hasMIME) {
            QName bQName = binding.getQName();
            TypeMapping typeMapping = WSDDFactory.INSTANCE.createTypeMapping();
            typeMapping.setQname(new QName(bQName.getNamespaceURI(), "DataHandler"));
            typeMapping.setType(new QName("http://xml.apache.org/axis/wsdd/providers/java", "javax.activation.DataHandler", "java"));
            typeMapping.setSerializer("org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory");
            typeMapping.setDeserializer("org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory");
            typeMapping.setEncodingStyle(use.getEncoding());
            service.getTypeMappings().add(typeMapping);
        }
        Map types = this.symbolTable.getTypeIndex();
        Collection typeCollection = types.values();
        Iterator i = typeCollection.iterator();
        while (i.hasNext()) {
            String deserializerFactory;
            String serializerFactory;
            TypeEntry type = (TypeEntry)i.next();
            boolean process = true;
            if (!Utils.shouldEmit(type)) {
                process = false;
            }
            if (!process) continue;
            String javaType = type.getName();
            String encodingStyle = "";
            QName innerType = null;
            if (!hasLiteral) {
                encodingStyle = use.getEncoding();
            }
            if (javaType.endsWith("[]")) {
                if (SchemaUtils.isListWithItemType((Node)type.getNode())) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleListSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleListDeserializerFactory";
                } else {
                    serializerFactory = "org.apache.axis.encoding.ser.ArraySerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
                    innerType = type.getComponentType();
                }
            } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues(type.getNode(), this.symbolTable) != null) {
                serializerFactory = "org.apache.axis.encoding.ser.EnumSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.EnumDeserializerFactory";
            } else if (type.isSimpleType()) {
                serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else if (type.getBaseType() != null) {
                serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else {
                serializerFactory = "org.apache.axis.encoding.ser.BeanSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.BeanDeserializerFactory";
            }
            if (innerType == null) {
                TypeMapping typeMapping = WSDDFactory.INSTANCE.createTypeMapping();
                typeMapping.setQname(type.getQName());
                typeMapping.setType(new QName("http://xml.apache.org/axis/wsdd/providers/java", javaType));
                typeMapping.setSerializer(serializerFactory);
                typeMapping.setDeserializer(deserializerFactory);
                typeMapping.setEncodingStyle(encodingStyle);
                service.getTypeMappings().add(typeMapping);
                continue;
            }
            ArrayMapping arrayMapping = WSDDFactory.INSTANCE.createArrayMapping();
            arrayMapping.setQname(type.getQName());
            arrayMapping.setType(new QName("http://xml.apache.org/axis/wsdd/providers/java", javaType));
            arrayMapping.setEncodingStyle(encodingStyle);
            arrayMapping.setInnerType(innerType);
            service.getArrayMappings().add(arrayMapping);
        }
    }

    protected void writeDeployPort(Deployment deployment, Port port, javax.wsdl.Service service, BindingEntry bEntry) throws IOException {
        Style style;
        String serviceName = port.getName();
        boolean hasLiteral = bEntry.hasLiteral();
        boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
        Iterator iterator = bEntry.getBinding().getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof SOAPBinding) && !(obj instanceof SOAP12Binding)) continue;
            this.use = Use.ENCODED;
        }
        if (this.symbolTable.isWrapped()) {
            style = Style.WRAPPED;
            this.use = Use.LITERAL;
        } else {
            style = bEntry.getBindingStyle();
            if (hasLiteral) {
                this.use = Use.LITERAL;
            }
        }
        Service wsddService = WSDDFactory.INSTANCE.createService();
        wsddService.setName(serviceName);
        wsddService.setProvider(new QName("http://xml.apache.org/axis/wsdd/providers/java", "RPC"));
        wsddService.setStyle(style);
        wsddService.setUse(this.use);
        wsddService.setParameter("wsdlTargetNamespace", service.getQName().getNamespaceURI());
        wsddService.setParameter("wsdlServiceElement", service.getQName().getLocalPart());
        if (hasMIME) {
            wsddService.setParameter("sendMultiRefs", "false");
        }
        ArrayList qualified = new ArrayList();
        ArrayList unqualified = new ArrayList();
        Map elementFormDefaults = this.symbolTable.getElementFormDefaults();
        Iterator it = elementFormDefaults.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue().equals("qualified")) {
                qualified.add(entry.getKey());
                continue;
            }
            unqualified.add(entry.getKey());
        }
        if (qualified.size() > 0) {
            wsddService.setParameter("schemaQualified", StringUtils.join(qualified, (char)','));
        }
        if (unqualified.size() > 0) {
            wsddService.setParameter("schemaUnqualified", StringUtils.join(unqualified, (char)','));
        }
        wsddService.setParameter("wsdlServicePort", serviceName);
        this.writeDeployBinding(wsddService, bEntry);
        this.writeDeployTypes(wsddService, bEntry.getBinding(), hasLiteral, hasMIME, this.use);
        deployment.getServices().add(wsddService);
    }

    protected void writeDeployBinding(Service service, BindingEntry bEntry) throws IOException {
        String customClassName;
        Binding binding = bEntry.getBinding();
        String className = bEntry.getName();
        className = this.emitter.isSkeletonWanted() ? className + "Skeleton" : ((customClassName = this.emitter.getImplementationClassName()) != null ? customClassName : className + "Impl");
        service.setParameter("className", className);
        service.setParameter("wsdlPortType", binding.getPortType().getQName().getLocalPart());
        service.setParameter("typeMappingVersion", this.emitter.getTypeMappingVersion());
        HashSet<String> allowedMethods = new HashSet<String>();
        String namespaceURI = binding.getQName().getNamespaceURI();
        if (!this.emitter.isSkeletonWanted()) {
            Iterator operationsIterator = binding.getBindingOperations().iterator();
            while (operationsIterator.hasNext()) {
                BindingOperation bindingOper = (BindingOperation)operationsIterator.next();
                Operation operation = bindingOper.getOperation();
                OperationType type = operation.getStyle();
                if (OperationType.NOTIFICATION.equals(type) || OperationType.SOLICIT_RESPONSE.equals(type)) continue;
                String javaOperName = null;
                ServiceDesc serviceDesc = this.emitter.getServiceDesc();
                if (this.emitter.isDeploy() && serviceDesc != null) {
                    OperationDesc[] operDescs = serviceDesc.getOperationsByQName(new QName(namespaceURI, operation.getName()));
                    if (operDescs.length == 0) {
                        log.warn((Object)("Can't find operation in the Java Class for WSDL binding operation : " + operation.getName()));
                        continue;
                    }
                    OperationDesc operDesc = operDescs[0];
                    if (operDesc.getMethod() == null) {
                        log.warn((Object)("Can't find Java method for operation descriptor : " + operDesc.getName()));
                        continue;
                    }
                    javaOperName = operDesc.getMethod().getName();
                } else {
                    javaOperName = JavaUtils.xmlNameToJava((String)operation.getName());
                }
                allowedMethods.add(javaOperName);
                Parameters params = this.symbolTable.getOperationParameters(operation, "", bEntry);
                if (params == null) continue;
                QName elementQName = Utils.getOperationQName((BindingOperation)bindingOper, (BindingEntry)bEntry, (SymbolTable)this.symbolTable);
                QName returnQName = null;
                QName returnType = null;
                if (params.returnParam != null) {
                    returnQName = params.returnParam.getQName();
                    returnType = Utils.getXSIType((Parameter)params.returnParam);
                }
                HashMap faultMap = bEntry.getFaults();
                ArrayList faults = null;
                if (faultMap != null) {
                    faults = (ArrayList)faultMap.get(bindingOper);
                }
                String SOAPAction = Utils.getOperationSOAPAction(bindingOper);
                this.writeOperation(service, javaOperName, elementQName, returnQName, returnType, params, binding.getQName(), faults, SOAPAction);
            }
        }
        service.setParameter("allowedMethods", allowedMethods.isEmpty() ? "*" : StringUtils.join(allowedMethods, (char)' '));
        Scope scope = this.emitter.getScope();
        if (scope != null) {
            service.setParameter("scope", scope.getName());
        }
    }

    protected void writeOperation(Service service, String javaOperName, QName elementQName, QName returnQName, QName returnType, Parameters params, QName bindingQName, ArrayList faults, String SOAPAction) {
        org.apache.axis.model.wsdd.Operation operation = WSDDFactory.INSTANCE.createOperation();
        operation.setName(javaOperName);
        operation.setQname(elementQName);
        if (returnQName != null) {
            operation.setReturnQName(new QName(returnQName.getNamespaceURI(), Utils.getLastLocalPart((String)returnQName.getLocalPart())));
        }
        operation.setReturnType(returnType);
        Parameter retParam = params.returnParam;
        if (retParam != null) {
            TypeEntry type = retParam.getType();
            operation.setReturnItemQName(Utils.getItemQName(type));
            if (this.use == Use.ENCODED) {
                operation.setReturnItemType(Utils.getItemType(type));
            }
        }
        operation.setSoapAction(SOAPAction);
        if (!OperationType.REQUEST_RESPONSE.equals(params.mep)) {
            operation.setMep(this.getMepString(params.mep));
        }
        if (params.returnParam != null && params.returnParam.isOutHeader()) {
            operation.setReturnHeader(Boolean.TRUE);
        }
        Vector paramList = params.list;
        for (int i = 0; i < paramList.size(); ++i) {
            Parameter param = (Parameter)paramList.elementAt(i);
            QName paramQName = param.getQName();
            QName paramType = Utils.getXSIType((Parameter)param);
            OperationParameter parameter = WSDDFactory.INSTANCE.createOperationParameter();
            if (paramQName == null) {
                parameter.setName(param.getName());
            } else {
                parameter.setQname(new QName(paramQName.getNamespaceURI(), Utils.getLastLocalPart((String)paramQName.getLocalPart())));
            }
            parameter.setType(paramType);
            if (param.getMode() != 1) {
                parameter.setMode(ParameterMode.get((int)param.getMode()));
            }
            if (param.isInHeader()) {
                parameter.setInHeader(Boolean.TRUE);
            }
            if (param.isOutHeader()) {
                parameter.setOutHeader(Boolean.TRUE);
            }
            parameter.setItemQName(Utils.getItemQName(param.getType()));
            operation.getParameters().add(parameter);
        }
        if (faults != null) {
            Iterator iterator = faults.iterator();
            while (iterator.hasNext()) {
                FaultInfo faultInfo = (FaultInfo)iterator.next();
                QName faultQName = faultInfo.getQName();
                if (faultQName == null) continue;
                String className = Utils.getFullExceptionName(faultInfo.getMessage(), this.symbolTable);
                Fault fault = WSDDFactory.INSTANCE.createFault();
                fault.setName(faultInfo.getName());
                fault.setQname(faultQName);
                fault.setClass(className);
                fault.setType(faultInfo.getXMLType());
                operation.getFaults().add(fault);
            }
        }
        service.getOperations().add(operation);
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        return new PrintWriter(writer);
    }

    String getMepString(OperationType mep) {
        return (String)mepStrings.get(mep.toString());
    }

    static {
        mepStrings.put(OperationType.REQUEST_RESPONSE.toString(), "request-response");
        mepStrings.put(OperationType.ONE_WAY.toString(), "oneway");
    }
}

