/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.store.DeleteType;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static final Logger METRICS = LoggerFactory.getLogger((String)"METRICS");
    private static final ThreadLocal<RequestContext> CURRENT_CONTEXT = new ThreadLocal();
    private static final Set<RequestContext> ACTIVE_REQUESTS = new HashSet<RequestContext>();
    private static final boolean isMetricsEnabled = METRICS.isDebugEnabled();
    private final long requestTime = System.currentTimeMillis();
    private final Map<String, AtlasEntityHeader> updatedEntities = new HashMap<String, AtlasEntityHeader>();
    private final Map<String, AtlasEntityHeader> deletedEntities = new HashMap<String, AtlasEntityHeader>();
    private final Map<String, AtlasEntity> entityCache = new HashMap<String, AtlasEntity>();
    private final Map<String, AtlasEntity.AtlasEntityWithExtInfo> entityExtInfoCache = new HashMap<String, AtlasEntity.AtlasEntityWithExtInfo>();
    private final Map<String, List<AtlasClassification>> addedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final Map<String, List<AtlasClassification>> removedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final AtlasPerfMetrics metrics = isMetricsEnabled ? new AtlasPerfMetrics() : null;
    private List<EntityGuidPair> entityGuidInRequest = null;
    private String user;
    private Set<String> userGroups;
    private String clientIPAddress;
    private DeleteType deleteType = DeleteType.DEFAULT;
    private int maxAttempts = 1;
    private int attemptCount = 1;
    private boolean isImportInProgress = false;
    private boolean isInNotificationProcessing = false;
    private boolean isInTypePatching = false;

    private RequestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestContext get() {
        RequestContext ret = CURRENT_CONTEXT.get();
        if (ret == null) {
            ret = new RequestContext();
            CURRENT_CONTEXT.set(ret);
            Set<RequestContext> set = ACTIVE_REQUESTS;
            synchronized (set) {
                ACTIVE_REQUESTS.add(ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RequestContext instance = CURRENT_CONTEXT.get();
        if (instance != null) {
            instance.clearCache();
            Set<RequestContext> set = ACTIVE_REQUESTS;
            synchronized (set) {
                ACTIVE_REQUESTS.remove(instance);
            }
        }
        CURRENT_CONTEXT.remove();
    }

    public void clearCache() {
        this.updatedEntities.clear();
        this.deletedEntities.clear();
        this.entityCache.clear();
        this.entityExtInfoCache.clear();
        this.addedPropagations.clear();
        this.removedPropagations.clear();
        if (this.metrics != null && !this.metrics.isEmpty()) {
            METRICS.debug(this.metrics.toString());
            this.metrics.clear();
        }
        if (this.entityGuidInRequest != null) {
            this.entityGuidInRequest.clear();
        }
    }

    public static String getCurrentUser() {
        RequestContext context = CURRENT_CONTEXT.get();
        return context != null ? context.getUser() : null;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUser(String user, Set<String> userGroups) {
        this.user = user;
        this.userGroups = userGroups;
    }

    public DeleteType getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(DeleteType deleteType) {
        this.deleteType = deleteType == null ? DeleteType.DEFAULT : deleteType;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public boolean isImportInProgress() {
        return this.isImportInProgress;
    }

    public void setImportInProgress(boolean importInProgress) {
        this.isImportInProgress = importInProgress;
    }

    public boolean isInNotificationProcessing() {
        return this.isInNotificationProcessing;
    }

    public void setInNotificationProcessing(boolean inNotificationProcessing) {
        this.isInNotificationProcessing = inNotificationProcessing;
    }

    public boolean isInTypePatching() {
        return this.isInTypePatching;
    }

    public void setInTypePatching(boolean inTypePatching) {
        this.isInTypePatching = inTypePatching;
    }

    public void recordEntityUpdate(AtlasEntityHeader entity) {
        if (entity != null && entity.getGuid() != null) {
            this.updatedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordEntityDelete(AtlasEntityHeader entity) {
        if (entity != null && entity.getGuid() != null) {
            this.deletedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordAddedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.addedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.addedPropagations.put(guid, classifications);
        }
    }

    public static int getActiveRequestsCount() {
        return ACTIVE_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long earliestActiveRequestTime() {
        long ret = System.currentTimeMillis();
        Set<RequestContext> set = ACTIVE_REQUESTS;
        synchronized (set) {
            for (RequestContext context : ACTIVE_REQUESTS) {
                if (ret <= context.getRequestTime()) continue;
                ret = context.getRequestTime();
            }
        }
        return ret;
    }

    public void recordRemovedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.removedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.removedPropagations.put(guid, classifications);
        }
    }

    public Map<String, List<AtlasClassification>> getAddedPropagations() {
        return this.addedPropagations;
    }

    public Map<String, List<AtlasClassification>> getRemovedPropagations() {
        return this.removedPropagations;
    }

    public void cache(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity != null && entity.getEntity() != null && entity.getEntity().getGuid() != null) {
            this.entityExtInfoCache.put(entity.getEntity().getGuid(), entity);
            this.entityCache.put(entity.getEntity().getGuid(), entity.getEntity());
        }
    }

    public void cache(AtlasEntity entity) {
        if (entity != null && entity.getGuid() != null) {
            this.entityCache.put(entity.getGuid(), entity);
        }
    }

    public Collection<AtlasEntityHeader> getUpdatedEntities() {
        return this.updatedEntities.values();
    }

    public Collection<AtlasEntityHeader> getDeletedEntities() {
        return this.deletedEntities.values();
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityWithExtInfo(String guid) {
        return this.entityExtInfoCache.get(guid);
    }

    public AtlasEntity getEntity(String guid) {
        return this.entityCache.get(guid);
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isUpdatedEntity(String guid) {
        return this.updatedEntities.containsKey(guid);
    }

    public boolean isDeletedEntity(String guid) {
        return this.deletedEntities.containsKey(guid);
    }

    public AtlasPerfMetrics.MetricRecorder startMetricRecord(String name) {
        return this.metrics != null ? this.metrics.getMetricRecorder(name) : null;
    }

    public void endMetricRecord(AtlasPerfMetrics.MetricRecorder recorder) {
        if (this.metrics != null && recorder != null) {
            this.metrics.recordMetric(recorder);
        }
    }

    public void recordEntityGuidUpdate(AtlasEntity entity, String guidInRequest) {
        if (this.entityGuidInRequest == null) {
            this.entityGuidInRequest = new ArrayList<EntityGuidPair>();
        }
        this.entityGuidInRequest.add(new EntityGuidPair(entity, guidInRequest));
    }

    public void resetEntityGuidUpdates() {
        if (this.entityGuidInRequest != null) {
            for (EntityGuidPair entityGuidPair : this.entityGuidInRequest) {
                entityGuidPair.resetEntityGuid();
            }
        }
    }

    public class EntityGuidPair {
        private final AtlasEntity entity;
        private final String guid;

        public EntityGuidPair(AtlasEntity entity, String guid) {
            this.entity = entity;
            this.guid = guid;
        }

        public void resetEntityGuid() {
            this.entity.setGuid(this.guid);
        }
    }
}

