/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.SyncPutListener;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlClient
implements AutoCloseable {
    private final FlightClient client;

    public FlightSqlClient(FlightClient client) {
        this.client = Objects.requireNonNull(client, "Client cannot be null!");
    }

    public FlightInfo execute(String query, CallOption ... options) {
        FlightSql.CommandStatementQuery.Builder builder = FlightSql.CommandStatementQuery.newBuilder();
        builder.setQuery(query);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long executeUpdate(String query, CallOption ... options) {
        FlightSql.CommandStatementUpdate.Builder builder = FlightSql.CommandStatementUpdate.newBuilder();
        builder.setQuery(query);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        SyncPutListener putListener = new SyncPutListener();
        this.client.startPut(descriptor, VectorSchemaRoot.of((FieldVector[])new FieldVector[0]), (FlightClient.PutListener)putListener, options);
        try {
            PutResult read = putListener.read();
            try (ArrowBuf metadata = read.getApplicationMetadata();){
                FlightSql.DoPutUpdateResult doPutUpdateResult = FlightSql.DoPutUpdateResult.parseFrom(metadata.nioBuffer());
                long l = doPutUpdateResult.getRecordCount();
                return l;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw CallStatus.CANCELLED.withCause((Throwable)e).toRuntimeException();
        }
        catch (InvalidProtocolBufferException e) {
            throw CallStatus.INTERNAL.withCause((Throwable)e).toRuntimeException();
        }
    }

    public FlightInfo getCatalogs(CallOption ... options) {
        FlightSql.CommandGetCatalogs.Builder builder = FlightSql.CommandGetCatalogs.newBuilder();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getSchemas(String catalog, String dbSchemaFilterPattern, CallOption ... options) {
        FlightSql.CommandGetDbSchemas.Builder builder = FlightSql.CommandGetDbSchemas.newBuilder();
        if (catalog != null) {
            builder.setCatalog(catalog);
        }
        if (dbSchemaFilterPattern != null) {
            builder.setDbSchemaFilterPattern(dbSchemaFilterPattern);
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getSchema(FlightDescriptor descriptor, CallOption ... options) {
        return this.client.getSchema(descriptor, options);
    }

    public FlightStream getStream(Ticket ticket, CallOption ... options) {
        return this.client.getStream(ticket, options);
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo ... info) {
        return this.getSqlInfo(info, new CallOption[0]);
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo[] info, CallOption ... options) {
        int[] infoNumbers = Arrays.stream(info).mapToInt(FlightSql.SqlInfo::getNumber).toArray();
        return this.getSqlInfo(infoNumbers, options);
    }

    public FlightInfo getSqlInfo(int[] info, CallOption ... options) {
        return this.getSqlInfo(Arrays.stream(info).boxed().collect(Collectors.toList()), options);
    }

    public FlightInfo getSqlInfo(Iterable<Integer> info, CallOption ... options) {
        FlightSql.CommandGetSqlInfo.Builder builder = FlightSql.CommandGetSqlInfo.newBuilder();
        builder.addAllInfo(info);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getTables(String catalog, String dbSchemaFilterPattern, String tableFilterPattern, List<String> tableTypes, boolean includeSchema, CallOption ... options) {
        FlightSql.CommandGetTables.Builder builder = FlightSql.CommandGetTables.newBuilder();
        if (catalog != null) {
            builder.setCatalog(catalog);
        }
        if (dbSchemaFilterPattern != null) {
            builder.setDbSchemaFilterPattern(dbSchemaFilterPattern);
        }
        if (tableFilterPattern != null) {
            builder.setTableNameFilterPattern(tableFilterPattern);
        }
        if (tableTypes != null) {
            builder.addAllTableTypes(tableTypes);
        }
        builder.setIncludeSchema(includeSchema);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getPrimaryKeys(TableRef tableRef, CallOption ... options) {
        FlightSql.CommandGetPrimaryKeys.Builder builder = FlightSql.CommandGetPrimaryKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable()).build();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getExportedKeys(TableRef tableRef, CallOption ... options) {
        Objects.requireNonNull(tableRef.getTable(), "Table cannot be null.");
        FlightSql.CommandGetExportedKeys.Builder builder = FlightSql.CommandGetExportedKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable()).build();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getImportedKeys(TableRef tableRef, CallOption ... options) {
        Objects.requireNonNull(tableRef.getTable(), "Table cannot be null.");
        FlightSql.CommandGetImportedKeys.Builder builder = FlightSql.CommandGetImportedKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable()).build();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getCrossReference(TableRef pkTableRef, TableRef fkTableRef, CallOption ... options) {
        Objects.requireNonNull(pkTableRef.getTable(), "Parent Table cannot be null.");
        Objects.requireNonNull(fkTableRef.getTable(), "Foreign Table cannot be null.");
        FlightSql.CommandGetCrossReference.Builder builder = FlightSql.CommandGetCrossReference.newBuilder();
        if (pkTableRef.getCatalog() != null) {
            builder.setPkCatalog(pkTableRef.getCatalog());
        }
        if (pkTableRef.getDbSchema() != null) {
            builder.setPkDbSchema(pkTableRef.getDbSchema());
        }
        if (fkTableRef.getCatalog() != null) {
            builder.setFkCatalog(fkTableRef.getCatalog());
        }
        if (fkTableRef.getDbSchema() != null) {
            builder.setFkDbSchema(fkTableRef.getDbSchema());
        }
        builder.setPkTable(pkTableRef.getTable());
        builder.setFkTable(fkTableRef.getTable());
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getTableTypes(CallOption ... options) {
        FlightSql.CommandGetTableTypes.Builder builder = FlightSql.CommandGetTableTypes.newBuilder();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public PreparedStatement prepare(String query, CallOption ... options) {
        return new PreparedStatement(this.client, query, options);
    }

    @Override
    public void close() throws SQLException {
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public static class PreparedStatement
    implements AutoCloseable {
        private final FlightClient client;
        private final FlightSql.ActionCreatePreparedStatementResult preparedStatementResult;
        private VectorSchemaRoot parameterBindingRoot;
        private boolean isClosed;
        private Schema resultSetSchema;
        private Schema parameterSchema;

        public PreparedStatement(FlightClient client, String sql, CallOption ... options) {
            this.client = client;
            Action action = new Action(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_STATEMENT.getType(), Any.pack((Message)FlightSql.ActionCreatePreparedStatementRequest.newBuilder().setQuery(sql).build()).toByteArray());
            Iterator preparedStatementResults = client.doAction(action, options);
            this.preparedStatementResult = FlightSqlUtils.unpackAndParseOrThrow(((Result)preparedStatementResults.next()).getBody(), FlightSql.ActionCreatePreparedStatementResult.class);
            this.isClosed = false;
        }

        public void setParameters(VectorSchemaRoot parameterBindingRoot) {
            if (this.parameterBindingRoot != null) {
                if (this.parameterBindingRoot.equals(parameterBindingRoot)) {
                    return;
                }
                this.parameterBindingRoot.close();
            }
            this.parameterBindingRoot = parameterBindingRoot;
        }

        public void clearParameters() {
            if (this.parameterBindingRoot != null) {
                this.parameterBindingRoot.close();
            }
        }

        public Schema getResultSetSchema() {
            if (this.resultSetSchema == null) {
                ByteString bytes = this.preparedStatementResult.getDatasetSchema();
                this.resultSetSchema = this.deserializeSchema(bytes);
            }
            return this.resultSetSchema;
        }

        public Schema getParameterSchema() {
            if (this.parameterSchema == null) {
                ByteString bytes = this.preparedStatementResult.getParameterSchema();
                this.parameterSchema = this.deserializeSchema(bytes);
            }
            return this.parameterSchema;
        }

        private Schema deserializeSchema(ByteString bytes) {
            try {
                return bytes.isEmpty() ? new Schema(Collections.emptyList()) : MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(bytes.toByteArray()))));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize schema", e);
            }
        }

        public FlightInfo execute(CallOption ... options) throws SQLException {
            this.checkOpen();
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)FlightSql.CommandPreparedStatementQuery.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            if (this.parameterBindingRoot != null && this.parameterBindingRoot.getRowCount() > 0) {
                SyncPutListener putListener = new SyncPutListener();
                FlightClient.ClientStreamListener listener = this.client.startPut(descriptor, this.parameterBindingRoot, (FlightClient.PutListener)putListener, options);
                listener.putNext();
                listener.completed();
                listener.getResult();
            }
            return this.client.getInfo(descriptor, options);
        }

        protected final void checkOpen() {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Statement closed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long executeUpdate(CallOption ... options) {
            this.checkOpen();
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)FlightSql.CommandPreparedStatementUpdate.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            this.setParameters(this.parameterBindingRoot == null ? VectorSchemaRoot.of((FieldVector[])new FieldVector[0]) : this.parameterBindingRoot);
            SyncPutListener putListener = new SyncPutListener();
            FlightClient.ClientStreamListener listener = this.client.startPut(descriptor, this.parameterBindingRoot, (FlightClient.PutListener)putListener, options);
            listener.putNext();
            listener.completed();
            try {
                PutResult read = putListener.read();
                try (ArrowBuf metadata = read.getApplicationMetadata();){
                    FlightSql.DoPutUpdateResult doPutUpdateResult = FlightSql.DoPutUpdateResult.parseFrom(metadata.nioBuffer());
                    long l = doPutUpdateResult.getRecordCount();
                    return l;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw CallStatus.CANCELLED.withCause((Throwable)e).toRuntimeException();
            }
            catch (InvalidProtocolBufferException e) {
                throw CallStatus.INVALID_ARGUMENT.withCause((Throwable)e).toRuntimeException();
            }
        }

        public void close(CallOption ... options) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            Action action = new Action(FlightSqlUtils.FLIGHT_SQL_CLOSE_PREPARED_STATEMENT.getType(), Any.pack((Message)FlightSql.ActionClosePreparedStatementRequest.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            Iterator closePreparedStatementResults = this.client.doAction(action, options);
            closePreparedStatementResults.forEachRemaining(result -> {});
            if (this.parameterBindingRoot != null) {
                this.parameterBindingRoot.close();
            }
        }

        @Override
        public void close() {
            this.close(new CallOption[0]);
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

