/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache;

import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Node;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Pacer;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Ticker;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.WILSMS;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.WriteOrderDeque;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;

class WILSMSW<K, V>
extends WILSMS<K, V> {
    static final LocalCacheFactory FACTORY = WILSMSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WILSMSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

