/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDateVectorGetter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.utils.DateTimeUtils;

public class ArrowFlightJdbcDateVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final ArrowFlightJdbcDateVectorGetter.Getter getter;
    private final TimeUnit timeUnit;
    private final ArrowFlightJdbcDateVectorGetter.Holder holder = new ArrowFlightJdbcDateVectorGetter.Holder();

    public ArrowFlightJdbcDateVectorAccessor(DateDayVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcDateVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcDateVectorAccessor.getTimeUnitForVector(vector);
    }

    public ArrowFlightJdbcDateVectorAccessor(DateMilliVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcDateVectorGetter.createGetter(vector);
        this.timeUnit = ArrowFlightJdbcDateVectorAccessor.getTimeUnitForVector(vector);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject() {
        return this.getDate(null);
    }

    @Override
    public <T> T getObject(Class<T> type) throws SQLException {
        Object value;
        if (type == LocalDate.class) {
            value = this.getLocalDate();
        } else if (type == Date.class) {
            value = this.getObject();
        } else {
            throw new SQLException("Object type not supported for Date Vector");
        }
        return (T)(!type.isPrimitive() && this.wasNull ? null : type.cast(value));
    }

    @Override
    public Date getDate(Calendar calendar) {
        this.fillHolder();
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        long milliseconds = this.timeUnit.toMillis(value);
        long millisWithCalendar = DateTimeUtils.applyCalendarOffset(milliseconds, calendar);
        return new Date(DateTimeUtils.getTimestampValue(millisWithCalendar).getTime());
    }

    private void fillHolder() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        Date date = this.getDate(calendar);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    @Override
    public String getString() {
        this.fillHolder();
        if (this.wasNull) {
            return null;
        }
        long milliseconds = this.timeUnit.toMillis(this.holder.value);
        return org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.util.DateTimeUtils.unixDateToString((int)(milliseconds / 86400000L));
    }

    protected static TimeUnit getTimeUnitForVector(ValueVector vector) {
        if (vector instanceof DateDayVector) {
            return TimeUnit.DAYS;
        }
        if (vector instanceof DateMilliVector) {
            return TimeUnit.MILLISECONDS;
        }
        throw new IllegalArgumentException("Invalid Arrow vector");
    }

    private LocalDate getLocalDate() {
        return this.getDate(null).toLocalDate();
    }
}

