/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.frodo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.jcajce.interfaces.FrodoKey;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.jcajce.spec.FrodoParameterSpec;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.util.Arrays;

public class BCFrodoPublicKey
implements PublicKey,
FrodoKey {
    private static final long serialVersionUID = 1L;
    private transient FrodoPublicKeyParameters params;

    public BCFrodoPublicKey(FrodoPublicKeyParameters frodoPublicKeyParameters) {
        this.params = frodoPublicKeyParameters;
    }

    public BCFrodoPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (FrodoPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCFrodoPublicKey) {
            BCFrodoPublicKey bCFrodoPublicKey = (BCFrodoPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCFrodoPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "Frodo";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public FrodoParameterSpec getParameterSpec() {
        return FrodoParameterSpec.fromName(this.params.getParameters().getName());
    }

    FrodoPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

