/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.ImmutableList;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.Iterables;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.io.ByteStreams;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ByteString;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.CodedInputStream;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Drainable;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.MethodDescriptor;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.protobuf.ProtoUtils;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.ByteBuf;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.Unpooled;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.AddWritableBuffer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.GetReadableBuffer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;

class ArrowMessage
implements AutoCloseable {
    public static final boolean ENABLE_ZERO_COPY_READ;
    public static final boolean ENABLE_ZERO_COPY_WRITE;
    private static final int DESCRIPTOR_TAG = 10;
    private static final int BODY_TAG = 8002;
    private static final int HEADER_TAG = 18;
    private static final int APP_METADATA_TAG = 26;
    private static final MethodDescriptor.Marshaller<Flight.FlightData> NO_BODY_MARSHALLER;
    private static final List<ByteBuf> PADDING_BUFFERS;
    private final IpcOption writeOption;
    private final Flight.FlightDescriptor descriptor;
    private final MessageMetadataResult message;
    private final ArrowBuf appMetadata;
    private final List<ArrowBuf> bufs;
    private final boolean tryZeroCopyWrite;

    public ArrowBuf getApplicationMetadata() {
        return this.appMetadata;
    }

    public ArrowMessage(Flight.FlightDescriptor descriptor, Schema schema, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(schema, this.writeOption);
        this.message = MessageMetadataResult.create(serializedMessage.slice(), serializedMessage.remaining());
        this.bufs = ImmutableList.of();
        this.descriptor = descriptor;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(ArrowRecordBatch batch, ArrowBuf appMetadata, boolean tryZeroCopy, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(batch, this.writeOption);
        this.message = MessageMetadataResult.create(serializedMessage.slice(), serializedMessage.remaining());
        this.bufs = ImmutableList.copyOf(batch.getBuffers());
        this.descriptor = null;
        this.appMetadata = appMetadata;
        this.tryZeroCopyWrite = tryZeroCopy;
    }

    public ArrowMessage(ArrowDictionaryBatch batch, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(batch, this.writeOption);
        serializedMessage = serializedMessage.slice();
        this.message = MessageMetadataResult.create(serializedMessage, serializedMessage.remaining());
        batch.getDictionary().getBuffers().forEach(buf -> buf.getReferenceManager().retain());
        this.bufs = ImmutableList.copyOf(batch.getDictionary().getBuffers());
        this.descriptor = null;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(ArrowBuf appMetadata) {
        this.writeOption = IpcOption.DEFAULT;
        this.message = null;
        this.bufs = ImmutableList.of();
        this.descriptor = null;
        this.appMetadata = appMetadata;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(Flight.FlightDescriptor descriptor) {
        this.writeOption = IpcOption.DEFAULT;
        this.message = null;
        this.bufs = ImmutableList.of();
        this.descriptor = descriptor;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    private ArrowMessage(Flight.FlightDescriptor descriptor, MessageMetadataResult message, ArrowBuf appMetadata, ArrowBuf buf) {
        this.writeOption = message != null ? new IpcOption(false, MetadataVersion.fromFlatbufID(message.getMessage().version())) : IpcOption.DEFAULT;
        this.message = message;
        this.descriptor = descriptor;
        this.appMetadata = appMetadata;
        this.bufs = buf == null ? ImmutableList.of() : ImmutableList.of(buf);
        this.tryZeroCopyWrite = false;
    }

    public MessageMetadataResult asSchemaMessage() {
        return this.message;
    }

    public Flight.FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public HeaderType getMessageType() {
        if (this.message == null) {
            return HeaderType.NONE;
        }
        return HeaderType.getHeader(this.message.headerType());
    }

    public Schema asSchema() {
        Preconditions.checkArgument(this.bufs.size() == 0);
        Preconditions.checkArgument(this.getMessageType() == HeaderType.SCHEMA);
        return MessageSerializer.deserializeSchema(this.message);
    }

    public ArrowRecordBatch asRecordBatch() throws IOException {
        Preconditions.checkArgument(this.bufs.size() == 1, "A batch can only be consumed if it contains a single ArrowBuf.");
        Preconditions.checkArgument(this.getMessageType() == HeaderType.RECORD_BATCH);
        ArrowBuf underlying = this.bufs.get(0);
        underlying.getReferenceManager().retain();
        return MessageSerializer.deserializeRecordBatch(this.message, underlying);
    }

    public ArrowDictionaryBatch asDictionaryBatch() throws IOException {
        Preconditions.checkArgument(this.bufs.size() == 1, "A batch can only be consumed if it contains a single ArrowBuf.");
        Preconditions.checkArgument(this.getMessageType() == HeaderType.DICTIONARY_BATCH);
        ArrowBuf underlying = this.bufs.get(0);
        underlying.getReferenceManager().retain();
        return MessageSerializer.deserializeDictionaryBatch(this.message, underlying);
    }

    public Iterable<ArrowBuf> getBufs() {
        return Iterables.unmodifiableIterable(this.bufs);
    }

    private static ArrowMessage frame(BufferAllocator allocator, InputStream stream) {
        try {
            Flight.FlightDescriptor descriptor = null;
            MessageMetadataResult header = null;
            ArrowBuf body = null;
            ArrowBuf appMetadata = null;
            while (stream.available() > 0) {
                int tag = ArrowMessage.readRawVarint32(stream);
                switch (tag) {
                    case 10: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully(stream, bytes);
                        descriptor = Flight.FlightDescriptor.parseFrom(bytes);
                        break;
                    }
                    case 18: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully(stream, bytes);
                        header = MessageMetadataResult.create(ByteBuffer.wrap(bytes), size);
                        break;
                    }
                    case 26: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        appMetadata = allocator.buffer(size);
                        GetReadableBuffer.readIntoBuffer(stream, appMetadata, size, ENABLE_ZERO_COPY_READ);
                        break;
                    }
                    case 8002: {
                        if (body != null) {
                            body.getReferenceManager().release();
                            body = null;
                        }
                        int size = ArrowMessage.readRawVarint32(stream);
                        body = allocator.buffer(size);
                        GetReadableBuffer.readIntoBuffer(stream, body, size, ENABLE_ZERO_COPY_READ);
                        break;
                    }
                }
            }
            if (header != null) {
                switch (HeaderType.getHeader(header.headerType()).ordinal()) {
                    case 1: {
                        if (body == null || body.capacity() != 0L) break;
                        body.close();
                        body = null;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (body != null) break;
                        body = allocator.getEmpty();
                        break;
                    }
                }
            }
            return new ArrowMessage(descriptor, header, appMetadata, body);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static int readRawVarint32(InputStream is) throws IOException {
        int firstByte = is.read();
        return CodedInputStream.readRawVarint32(firstByte, is);
    }

    private InputStream asInputStream() {
        if (this.message == null) {
            Flight.FlightData.Builder builder = Flight.FlightData.newBuilder();
            if (this.descriptor != null) {
                builder.setFlightDescriptor(this.descriptor);
            }
            if (this.appMetadata != null) {
                builder.setAppMetadata(ByteString.copyFrom(this.appMetadata.nioBuffer()));
            }
            return NO_BODY_MARSHALLER.stream(builder.build());
        }
        try {
            ByteString bytes = ByteString.copyFrom(this.message.getMessageBuffer(), this.message.bytesAfterMessage());
            if (this.getMessageType() == HeaderType.SCHEMA) {
                Flight.FlightData.Builder builder = Flight.FlightData.newBuilder().setDataHeader(bytes);
                if (this.descriptor != null) {
                    builder.setFlightDescriptor(this.descriptor);
                }
                Preconditions.checkArgument(this.bufs.isEmpty());
                return NO_BODY_MARSHALLER.stream(builder.build());
            }
            Preconditions.checkArgument(this.getMessageType() == HeaderType.RECORD_BATCH || this.getMessageType() == HeaderType.DICTIONARY_BATCH);
            Preconditions.checkArgument(this.descriptor == null, "Descriptor should only be included in the schema message.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CodedOutputStream cos = CodedOutputStream.newInstance(baos);
            cos.writeBytes(2, bytes);
            if (this.appMetadata != null && this.appMetadata.capacity() > 0L) {
                cos.writeByteBuffer(3, this.appMetadata.nioBuffer().slice());
            }
            cos.writeTag(1000, 2);
            int size = 0;
            ArrayList<ByteBuf> allBufs = new ArrayList<ByteBuf>();
            for (ArrowBuf b : this.bufs) {
                allBufs.add(Unpooled.wrappedBuffer(b.nioBuffer()).retain());
                size += (int)b.readableBytes();
                if (b.readableBytes() % 8L == 0L) continue;
                int paddingBytes = (int)(8L - b.readableBytes() % 8L);
                assert (paddingBytes > 0 && paddingBytes < 8);
                size += paddingBytes;
                allBufs.add(PADDING_BUFFERS.get(paddingBytes).retain());
            }
            cos.writeUInt32NoTag(size);
            cos.flush();
            ByteBuf initialBuf = Unpooled.buffer(baos.size());
            initialBuf.writeBytes(baos.toByteArray());
            ImmutableCollection byteBufs = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(initialBuf)).addAll(allBufs)).build();
            int maxNumComponents = Integer.MAX_VALUE;
            CompositeByteBuf bb = this.tryZeroCopyWrite ? new ArrowBufRetainingCompositeByteBuf(Integer.MAX_VALUE, byteBufs, this.bufs) : new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, Integer.MAX_VALUE, byteBufs);
            return new DrainableByteBufInputStream(bb, this.tryZeroCopyWrite);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected IO Exception", ex);
        }
    }

    public static MethodDescriptor.Marshaller<ArrowMessage> createMarshaller(BufferAllocator allocator) {
        return new ArrowMessageHolderMarshaller(allocator);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(Iterables.concat(this.bufs, Collections.singletonList(this.appMetadata)));
    }

    static {
        String zeroCopyWriteFlag;
        String zeroCopyReadFlag = System.getProperty("arrow.flight.enable_zero_copy_read");
        if (zeroCopyReadFlag == null) {
            zeroCopyReadFlag = System.getenv("ARROW_FLIGHT_ENABLE_ZERO_COPY_READ");
        }
        if ((zeroCopyWriteFlag = System.getProperty("arrow.flight.enable_zero_copy_write")) == null) {
            zeroCopyWriteFlag = System.getenv("ARROW_FLIGHT_ENABLE_ZERO_COPY_WRITE");
        }
        ENABLE_ZERO_COPY_READ = !"false".equalsIgnoreCase(zeroCopyReadFlag);
        ENABLE_ZERO_COPY_WRITE = "true".equalsIgnoreCase(zeroCopyWriteFlag);
        NO_BODY_MARSHALLER = ProtoUtils.marshaller(Flight.FlightData.getDefaultInstance());
        PADDING_BUFFERS = Arrays.asList(null, Unpooled.copiedBuffer(new byte[]{0}), Unpooled.copiedBuffer(new byte[]{0, 0}), Unpooled.copiedBuffer(new byte[]{0, 0, 0}), Unpooled.copiedBuffer(new byte[]{0, 0, 0, 0}), Unpooled.copiedBuffer(new byte[]{0, 0, 0, 0, 0}), Unpooled.copiedBuffer(new byte[]{0, 0, 0, 0, 0, 0}), Unpooled.copiedBuffer(new byte[]{0, 0, 0, 0, 0, 0, 0}));
    }

    public static enum HeaderType {
        NONE,
        SCHEMA,
        DICTIONARY_BATCH,
        RECORD_BATCH,
        TENSOR;


        public static HeaderType getHeader(byte b) {
            switch (b) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return SCHEMA;
                }
                case 2: {
                    return DICTIONARY_BATCH;
                }
                case 3: {
                    return RECORD_BATCH;
                }
                case 4: {
                    return TENSOR;
                }
            }
            throw new UnsupportedOperationException("unknown type: " + b);
        }
    }

    private static final class ArrowBufRetainingCompositeByteBuf
    extends CompositeByteBuf {
        final List<ArrowBuf> backingBuffers;
        boolean freed;

        ArrowBufRetainingCompositeByteBuf(int maxNumComponents, Iterable<ByteBuf> buffers, List<ArrowBuf> backingBuffers) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxNumComponents, buffers);
            this.backingBuffers = backingBuffers;
            this.freed = false;
            for (int i = 0; i < backingBuffers.size(); ++i) {
                backingBuffers.get(i).getReferenceManager().retain();
            }
        }

        @Override
        protected void deallocate() {
            super.deallocate();
            if (this.freed) {
                return;
            }
            this.freed = true;
            for (int i = 0; i < this.backingBuffers.size(); ++i) {
                this.backingBuffers.get(i).getReferenceManager().release();
            }
        }
    }

    private static class DrainableByteBufInputStream
    extends ByteBufInputStream
    implements Drainable {
        private final CompositeByteBuf buf;
        private final boolean isZeroCopy;

        public DrainableByteBufInputStream(CompositeByteBuf buffer, boolean isZeroCopy) {
            super(buffer, buffer.readableBytes(), true);
            this.buf = buffer;
            this.isZeroCopy = isZeroCopy;
        }

        @Override
        public int drainTo(OutputStream target) throws IOException {
            int size = this.buf.readableBytes();
            AddWritableBuffer.add(this.buf, target, this.isZeroCopy);
            return size;
        }

        @Override
        public void close() {
            this.buf.release();
        }
    }

    private static class ArrowMessageHolderMarshaller
    implements MethodDescriptor.Marshaller<ArrowMessage> {
        private final BufferAllocator allocator;

        public ArrowMessageHolderMarshaller(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public InputStream stream(ArrowMessage value) {
            return value.asInputStream();
        }

        @Override
        public ArrowMessage parse(InputStream stream) {
            return ArrowMessage.frame(this.allocator, stream);
        }
    }
}

