/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ByteString;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.Timestamp;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.util.Timestamps;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Location;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Ticket;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;

public class FlightEndpoint {
    private final List<Location> locations;
    private final Ticket ticket;
    private final Instant expirationTime;
    private final byte[] appMetadata;

    public FlightEndpoint(Ticket ticket, Location ... locations) {
        this(ticket, (Instant)null, locations);
    }

    public FlightEndpoint(Ticket ticket, Instant expirationTime, Location ... locations) {
        this(ticket, expirationTime, null, Collections.unmodifiableList(new ArrayList<Location>(Arrays.asList(locations))));
    }

    private FlightEndpoint(Ticket ticket, Instant expirationTime, byte[] appMetadata, List<Location> locations) {
        Objects.requireNonNull(ticket);
        this.locations = locations;
        this.expirationTime = expirationTime;
        this.ticket = ticket;
        this.appMetadata = appMetadata;
    }

    FlightEndpoint(Flight.FlightEndpoint flt) throws URISyntaxException {
        this.locations = new ArrayList<Location>();
        for (Flight.Location location : flt.getLocationList()) {
            this.locations.add(new Location(location.getUri()));
        }
        this.expirationTime = flt.hasExpirationTime() ? Instant.ofEpochSecond(flt.getExpirationTime().getSeconds(), Timestamps.toNanos(flt.getExpirationTime())) : null;
        this.appMetadata = flt.getAppMetadata().isEmpty() ? null : flt.getAppMetadata().toByteArray();
        this.ticket = new Ticket(flt.getTicket());
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public Optional<Instant> getExpirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    public byte[] getAppMetadata() {
        return this.appMetadata;
    }

    Flight.FlightEndpoint toProtocol() {
        Flight.FlightEndpoint.Builder b = Flight.FlightEndpoint.newBuilder().setTicket(this.ticket.toProtocol());
        for (Location l : this.locations) {
            b.addLocation(l.toProtocol());
        }
        if (this.expirationTime != null) {
            b.setExpirationTime(Timestamp.newBuilder().setSeconds(this.expirationTime.getEpochSecond()).setNanos(this.expirationTime.getNano()).build());
        }
        if (this.appMetadata != null) {
            b.setAppMetadata(ByteString.copyFrom(this.appMetadata));
        }
        return b.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static FlightEndpoint deserialize(ByteBuffer serialized) throws IOException, URISyntaxException {
        return new FlightEndpoint(Flight.FlightEndpoint.parseFrom(serialized));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlightEndpoint)) {
            return false;
        }
        FlightEndpoint that = (FlightEndpoint)o;
        return this.locations.equals(that.locations) && this.ticket.equals(that.ticket) && Objects.equals(this.expirationTime, that.expirationTime) && Arrays.equals(this.appMetadata, that.appMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.ticket, this.expirationTime, Arrays.hashCode(this.appMetadata));
    }

    public String toString() {
        return "FlightEndpoint{locations=" + String.valueOf(this.locations) + ", ticket=" + String.valueOf(this.ticket) + ", expirationTime=" + (this.expirationTime == null ? "(none)" : this.expirationTime.toString()) + ", appMetadata=" + (this.appMetadata == null ? "(none)" : Base64.getEncoder().encodeToString(this.appMetadata)) + "}";
    }

    public static Builder builder(Ticket ticket, Location ... locations) {
        return new Builder(ticket, locations);
    }

    public static final class Builder {
        private final Ticket ticket;
        private final List<Location> locations;
        private Instant expirationTime = null;
        private byte[] appMetadata = null;

        private Builder(Ticket ticket, Location ... locations) {
            this.ticket = ticket;
            this.locations = Collections.unmodifiableList(new ArrayList<Location>(Arrays.asList(locations)));
        }

        public Builder setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder setAppMetadata(byte[] appMetadata) {
            this.appMetadata = appMetadata;
            return this;
        }

        public FlightEndpoint build() {
            return new FlightEndpoint(this.ticket, this.expirationTime, this.appMetadata, this.locations);
        }
    }
}

