/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class ConnectStringParser {
    private final String s;
    private final int n;
    private int i;
    private final StringBuilder nameBuf = new StringBuilder();
    private final StringBuilder valueBuf = new StringBuilder();

    private ConnectStringParser(String s) {
        this.s = s;
        this.i = 0;
        this.n = s.length();
    }

    public static Properties parse(String s) throws SQLException {
        return new ConnectStringParser(s).parseInternal(null);
    }

    public static Properties parse(String s, Properties props) throws SQLException {
        return new ConnectStringParser(s).parseInternal(props);
    }

    Properties parseInternal(Properties props) throws SQLException {
        Properties newProps = props == null ? new Properties() : (Properties)props.clone();
        while (this.i < this.n) {
            this.parsePair(newProps);
        }
        return newProps;
    }

    void parsePair(Properties props) throws SQLException {
        String value;
        String name = this.parseName();
        if (this.i >= this.n) {
            value = "";
        } else if (this.s.charAt(this.i) == ';') {
            ++this.i;
            value = "";
        } else {
            value = this.parseValue();
        }
        props.put(name, value);
    }

    String parseName() {
        this.nameBuf.setLength(0);
        block4: while (true) {
            char c = this.s.charAt(this.i);
            switch (c) {
                case '=': {
                    ++this.i;
                    if (this.i < this.n && (c = this.s.charAt(this.i)) == '=') {
                        ++this.i;
                        this.nameBuf.append(c);
                        continue block4;
                    }
                    String name = this.nameBuf.toString();
                    name = name.trim();
                    return name;
                }
                case ' ': {
                    if (this.nameBuf.length() != 0) break;
                    ++this.i;
                    continue block4;
                }
            }
            this.nameBuf.append(c);
            ++this.i;
            if (this.i >= this.n) break;
        }
        return this.nameBuf.toString().trim();
    }

    String parseValue() throws SQLException {
        String value;
        char c;
        while ((c = this.s.charAt(this.i)) == ' ') {
            ++this.i;
            if (this.i < this.n) continue;
            return "";
        }
        if (c == '\"' || c == '\'') {
            String value2 = this.parseQuoted(c);
            while (this.i < this.n && this.s.charAt(this.i) == ' ') {
                ++this.i;
            }
            if (this.i >= this.n) {
                return value2;
            }
            if (this.s.charAt(this.i) == ';') {
                ++this.i;
                return value2;
            }
            throw new SQLException("quoted value ended too soon, at position " + this.i + " in '" + this.s + "'");
        }
        int semi = this.s.indexOf(59, this.i);
        if (semi >= 0) {
            value = this.s.substring(this.i, semi);
            this.i = semi + 1;
        } else {
            value = this.s.substring(this.i);
            this.i = this.n;
        }
        return value.trim();
    }

    String parseQuoted(char q) throws SQLException {
        char c;
        if ((c = this.s.charAt(this.i++)) != q) {
            throw new AssertionError((Object)("c != q: c=" + c + " q=" + q));
        }
        this.valueBuf.setLength(0);
        while (this.i < this.n) {
            c = this.s.charAt(this.i);
            if (c == q) {
                ++this.i;
                if (this.i < this.n && (c = this.s.charAt(this.i)) == q) {
                    this.valueBuf.append(c);
                    ++this.i;
                    continue;
                }
                return this.valueBuf.toString();
            }
            this.valueBuf.append(c);
            ++this.i;
        }
        throw new SQLException("Connect string '" + this.s + "' contains unterminated quoted value '" + this.valueBuf.toString() + "'");
    }

    public static String getParamString(Properties props) {
        if (props == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : ConnectStringParser.toMap(props).entrySet()) {
            char q;
            boolean hasDQ;
            String name = entry.getKey();
            String value = entry.getValue();
            String quote = "";
            if (buf.length() > 0) {
                buf.append(';');
            }
            if (name.startsWith(" ") || name.endsWith(" ")) {
                quote = "'";
                buf.append(quote);
            }
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (c == '=') {
                    buf.append('=');
                }
                buf.append(c);
            }
            buf.append(quote);
            quote = "";
            buf.append('=');
            len = value.length();
            boolean hasSemi = value.indexOf(59) >= 0;
            boolean hasSQ = value.indexOf(39) >= 0;
            boolean bl = hasDQ = value.indexOf(34) >= 0;
            if (value.startsWith(" ") || value.endsWith(" ")) {
                quote = "'";
            } else if (hasSemi || hasSQ || hasDQ) {
                if (value.startsWith("\"")) {
                    quote = "'";
                } else if (value.startsWith("'")) {
                    quote = "\"";
                } else {
                    String string = quote = hasSQ ? "\"" : "'";
                }
            }
            if (quote.length() > 0) {
                buf.append(quote);
                q = quote.charAt(0);
            } else {
                q = '\u0000';
            }
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c == q) {
                    buf.append(q);
                }
                buf.append(c);
            }
            buf.append(quote);
        }
        return buf.toString();
    }

    public static Map<String, String> toMap(Properties properties) {
        return properties;
    }
}

