/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class AutoCloseables {
    private static final @UnknownKeyFor @NonNull @Initialized AutoCloseable noOpAutocloseable = new AutoCloseable(){

        @Override
        public void close() {
        }
    };

    private AutoCloseables() {
    }

    public static @UnknownKeyFor @NonNull @Initialized AutoCloseable all(final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AutoCloseable> autoCloseables) {
        return new AutoCloseable(){

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                AutoCloseables.close((Iterable<? extends AutoCloseable>)autoCloseables);
            }
        };
    }

    public static void close(@UnknownKeyFor @NonNull @Initialized Throwable t, AutoCloseable ... autoCloseables) {
        AutoCloseables.close(t, Arrays.asList(autoCloseables));
    }

    public static void close(@UnknownKeyFor @NonNull @Initialized Throwable t, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AutoCloseable> autoCloseables) {
        try {
            AutoCloseables.close(autoCloseables);
        }
        catch (Exception e) {
            t.addSuppressed(e);
        }
    }

    public static void close(AutoCloseable ... autoCloseables) throws @UnknownKeyFor @NonNull @Initialized Exception {
        AutoCloseables.close(Arrays.asList(autoCloseables));
    }

    public static void close(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AutoCloseable> ac) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (ac == null) {
            return;
        }
        if (ac instanceof AutoCloseable) {
            ((AutoCloseable)((Object)ac)).close();
            return;
        }
        Exception topLevelException = null;
        for (AutoCloseable autoCloseable : ac) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Exception e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                if (e == topLevelException) continue;
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }

    @SafeVarargs
    public static void close(Iterable<? extends AutoCloseable> ... closeables) throws @UnknownKeyFor @NonNull @Initialized Exception {
        AutoCloseables.close(AutoCloseables.flatten(closeables));
    }

    @SafeVarargs
    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized AutoCloseable> flatten(final Iterable<? extends AutoCloseable> ... closeables) {
        return new Iterable<AutoCloseable>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized AutoCloseable> iterator() {
                return Arrays.stream(closeables).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).iterator();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized AutoCloseable> iter(AutoCloseable ... ac) {
        if (ac.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AutoCloseable> nonNullAc = new ArrayList<AutoCloseable>();
        for (AutoCloseable autoCloseable : ac) {
            if (autoCloseable == null) continue;
            nonNullAc.add(autoCloseable);
        }
        return nonNullAc;
    }

    public static @UnknownKeyFor @NonNull @Initialized RollbackCloseable rollbackable(AutoCloseable ... closeables) {
        return new RollbackCloseable(closeables);
    }

    public static void closeNoChecked(@UnknownKeyFor @NonNull @Initialized AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while closing: " + e.getMessage(), e);
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized AutoCloseable noop() {
        return noOpAutocloseable;
    }

    public static class RollbackCloseable
    implements AutoCloseable {
        private @UnknownKeyFor @NonNull @Initialized boolean commit = false;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AutoCloseable> closeables;

        public RollbackCloseable(AutoCloseable ... closeables) {
            this.closeables = new ArrayList<AutoCloseable>(Arrays.asList(closeables));
        }

        public <T extends AutoCloseable> T add(T t) {
            this.closeables.add(t);
            return t;
        }

        public void addAll(AutoCloseable ... list) {
            this.closeables.addAll(Arrays.asList(list));
        }

        public void addAll(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AutoCloseable> list) {
            for (AutoCloseable autoCloseable : list) {
                this.closeables.add(autoCloseable);
            }
        }

        public void commit() {
            this.commit = true;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (!this.commit) {
                AutoCloseables.close(this.closeables);
            }
        }
    }
}

