/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.dataflow.qual.Pure;

public class SimpleHasher
implements ArrowBufHasher {
    public static @UnknownKeyFor @NonNull @Initialized SimpleHasher INSTANCE = new SimpleHasher();

    protected SimpleHasher() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized long address, @UnknownKeyFor @NonNull @Initialized long length) {
        int hashValue = 0;
        int index = 0;
        while ((long)(index + 8) <= length) {
            long longValue = MemoryUtil.UNSAFE.getLong(address + (long)index);
            int longHash = this.getLongHashCode(longValue);
            hashValue = this.combineHashCode(hashValue, longHash);
            index += 8;
        }
        if ((long)(index + 4) <= length) {
            int intValue;
            int intHash = intValue = MemoryUtil.UNSAFE.getInt(address + (long)index);
            hashValue = this.combineHashCode(hashValue, intHash);
            index += 4;
        }
        while ((long)index < length) {
            byte byteValue;
            byte byteHash = byteValue = MemoryUtil.UNSAFE.getByte(address + (long)index);
            hashValue = this.combineHashCode(hashValue, byteHash);
            ++index;
        }
        return this.finalizeHashCode(hashValue);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length) {
        buf.checkBytes(offset, offset + length);
        return this.hashCode(buf.memoryAddress() + offset, length);
    }

    protected @UnknownKeyFor @NonNull @Initialized int combineHashCode(@UnknownKeyFor @NonNull @Initialized int currentHashCode, @UnknownKeyFor @NonNull @Initialized int newHashCode) {
        return currentHashCode * 37 + newHashCode;
    }

    protected @UnknownKeyFor @NonNull @Initialized int getLongHashCode(@UnknownKeyFor @NonNull @Initialized long longValue) {
        return Long.hashCode(longValue);
    }

    protected @UnknownKeyFor @NonNull @Initialized int finalizeHashCode(@UnknownKeyFor @NonNull @Initialized int hashCode) {
        return hashCode;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return 123;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj != null && obj instanceof SimpleHasher;
    }
}

